% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduced_rank_regression.R
\name{cca_rrr_cv}
\alias{cca_rrr_cv}
\title{Cross-validated Canonical Correlation Analysis via RRR}
\usage{
cca_rrr_cv(
  X,
  Y,
  r = 2,
  lambdas = 10^seq(-3, 1.5, length.out = 100),
  kfolds = 14,
  solver = "ADMM",
  parallelize = FALSE,
  LW_Sy = TRUE,
  standardize = TRUE,
  rho = 1,
  thresh_0 = 1e-06,
  niter = 10000,
  thresh = 1e-04,
  verbose = FALSE,
  nb_cores = NULL
)
}
\arguments{
\item{X}{Matrix of predictors.}

\item{Y}{Matrix of responses.}

\item{r}{Rank of the solution.}

\item{lambdas}{Sequence of lambda values for cross-validation.}

\item{kfolds}{Number of folds for cross-validation.}

\item{solver}{Solver type: "rrr", "CVX", or "ADMM".}

\item{parallelize}{Logical; should cross-validation be parallelized?}

\item{LW_Sy}{Whether to use Ledoit-Wolf shrinkage for Sy.}

\item{standardize}{Logical; should X and Y be scaled.}

\item{rho}{ADMM parameter.}

\item{thresh_0}{tolerance for declaring entries non-zero}

\item{niter}{Maximum number of iterations for ADMM.}

\item{thresh}{Convergence threshold.}

\item{verbose}{Logical for verbose output.}

\item{nb_cores}{Number of cores to use for parallelization (default is all available cores minus 1)}
}
\value{
A list with elements:
\itemize{
\item U: Canonical direction matrix for X (p x r)
\item V: Canonical direction matrix for Y (q x r)
\item lambda: Optimal regularisation parameter lambda chosen by CV
\item rmse: Mean squared error of prediction (as computed in the CV)
\item cor: Canonical correlations
}
}
\description{
Performs cross-validation to select optimal lambda, fits CCA_rrr.
Canonical Correlation Analysis via Reduced Rank Regression (RRR)
}
