% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{texas}
\alias{texas}
\title{Data on prison capacity expansion in Texas}
\format{
A data frame with 816 rows and 12 variables
\describe{
\item{statefip}{State FIPS code}
\item{year}{Year}
\item{bmprison}{Number of Black men in prison}
\item{wmprison}{Number of White men in prison}
\item{alcohol}{Alcohol consumption per capita}
\item{income}{Median income}
\item{ur}{Unemployment rate}
\item{poverty}{Poverty rate}
\item{black}{Percentage of the population that is Black}
\item{perc1519}{Percentage of the population that is age 15-19}
\item{aidscapita}{AIDS mortality per 100,000 in t}
\item{state}{State name}
}
}
\source{
Cunningham and Kang. 2019. “Studying the Effect of Incarceration Shocks to Drug Markets.” Unpublished manuscript. \url{http://www.scunning.com/files/mass_incarceration_and_drug_abuse.pdf}
}
\usage{
texas
}
\description{
This data looks at the massive expansion in prison capacity in Texas that occurred in 1993 under Governor Ann Richards, and the effect of that expansion on the number of Black men in prison.
}
\details{
This data is used in the \emph{Synthetic Control} chapter of \emph{Causal Inference: The Mixtape} by Cunningham.
}
\references{
Cunningham. 2021. Causal Inference: The Mixtape. Yale Press. \url{https://mixtape.scunning.com/index.html}.
}
\keyword{datasets}
