% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format-caugi.R
\name{read_caugi}
\alias{read_caugi}
\title{Read caugi Graph from File}
\usage{
read_caugi(path, lazy = FALSE)
}
\arguments{
\item{path}{Character string specifying the file path.}

\item{lazy}{Logical; if \code{FALSE} (default), the graph is built immediately.
If \code{TRUE}, graph building is deferred until needed.}
}
\value{
A \code{caugi} object.
}
\description{
Reads a caugi graph from a file in the native caugi JSON format.
}
\details{
The function validates the file format and version, ensuring compatibility
with the current version of the caugi package.
}
\examples{
cg <- caugi(
  A \%-->\% B + C,
  class = "DAG"
)

# Write and read
tmp <- tempfile(fileext = ".caugi.json")
write_caugi(cg, tmp)
cg2 <- read_caugi(tmp)

# Clean up
unlink(tmp)

}
\seealso{
Other export: 
\code{\link{caugi_deserialize}()},
\code{\link{caugi_dot}()},
\code{\link{caugi_export}()},
\code{\link{caugi_graphml}()},
\code{\link{caugi_mermaid}()},
\code{\link{caugi_serialize}()},
\code{\link{export-classes}},
\code{\link{format-caugi}},
\code{\link{format-dot}},
\code{\link{format-graphml}},
\code{\link{format-mermaid}},
\code{\link{knit_print.caugi_export}},
\code{\link{read_graphml}()},
\code{\link{to_dot}()},
\code{\link{to_graphml}()},
\code{\link{to_mermaid}()},
\code{\link{write_caugi}()},
\code{\link{write_dot}()},
\code{\link{write_graphml}()},
\code{\link{write_mermaid}()}
}
\concept{export}
