% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{moralize}
\alias{moralize}
\title{Moralize a DAG}
\usage{
moralize(cg)
}
\arguments{
\item{cg}{A \code{caugi} object (DAG).}
}
\value{
A \code{caugi} object representing the moralized graph (UG).
}
\description{
Moralizing a DAG involves connecting all parents of each node and then
converting all directed edges into undirected edges.
}
\details{
This changes the graph from a Directed Acyclic Graph (DAG) to an
Undirected Graph (UG), also known as a Markov Graph.
}
\examples{
cg <- caugi(A \%-->\% C, B \%-->\% C, class = "DAG")
moralize(cg) # A -- B, A -- C, B -- C

}
\seealso{
Other operations: 
\code{\link{condition_marginalize}()},
\code{\link{exogenize}()},
\code{\link{latent_project}()},
\code{\link{mutate_caugi}()},
\code{\link{skeleton}()}
}
\concept{operations}
