% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustment.R
\name{is_valid_adjustment_admg}
\alias{is_valid_adjustment_admg}
\title{Is a set a valid adjustment set in an ADMG?}
\usage{
is_valid_adjustment_admg(
  cg,
  X = NULL,
  Y = NULL,
  Z = NULL,
  X_index = NULL,
  Y_index = NULL,
  Z_index = NULL
)
}
\arguments{
\item{cg}{A \code{caugi} object of class ADMG.}

\item{X, Y}{Node names (can be vectors for multiple treatments/outcomes).}

\item{Z}{Conditioning set (character vector of node names).}

\item{X_index, Y_index, Z_index}{Optional 1-based indices.}
}
\value{
Logical value indicating if the adjustment set is valid.
}
\description{
Checks whether \code{Z} is a valid adjustment set for estimating
the causal effect of \code{X} on \code{Y} in an ADMG using the generalized adjustment
criterion.
}
\examples{
# Classic confounding
cg <- caugi(
  L \%-->\% X,
  X \%-->\% Y,
  L \%-->\% Y,
  class = "ADMG"
)

is_valid_adjustment_admg(cg, X = "X", Y = "Y", Z = NULL) # FALSE
is_valid_adjustment_admg(cg, X = "X", Y = "Y", Z = "L") # TRUE

}
\seealso{
Other adjustment: 
\code{\link{adjustment_set}()},
\code{\link{all_adjustment_sets_admg}()},
\code{\link{all_backdoor_sets}()},
\code{\link{d_separated}()},
\code{\link{is_valid_backdoor}()}
}
\concept{adjustment}
