% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{exogenous}
\alias{exogenous}
\title{Get all exogenous nodes in a \code{caugi}}
\usage{
exogenous(cg, undirected_as_parents = FALSE)
}
\arguments{
\item{cg}{A \code{caugi} object.}

\item{undirected_as_parents}{Logical; if \code{TRUE}, undirected edges are treated
as (possible) parents, if \code{FALSE} (default), undirected edges are ignored.}
}
\value{
Either a character vector of node names (if a single node is
requested) or a list of character vectors (if multiple nodes are requested).
}
\description{
Get all exogenous nodes (nodes with no parents) in a
\code{caugi}.
}
\examples{
cg <- caugi(
  A \%-->\% B,
  B \%-->\% C,
  class = "DAG"
)
exogenous(cg) # "A"

}
\seealso{
Other queries: 
\code{\link{ancestors}()},
\code{\link{anteriors}()},
\code{\link{children}()},
\code{\link{descendants}()},
\code{\link{districts}()},
\code{\link{edge_types}()},
\code{\link{edges}()},
\code{\link{is_acyclic}()},
\code{\link{is_admg}()},
\code{\link{is_ag}()},
\code{\link{is_caugi}()},
\code{\link{is_cpdag}()},
\code{\link{is_dag}()},
\code{\link{is_empty_caugi}()},
\code{\link{is_mag}()},
\code{\link{is_pdag}()},
\code{\link{is_ug}()},
\code{\link{m_separated}()},
\code{\link{markov_blanket}()},
\code{\link{neighbors}()},
\code{\link{nodes}()},
\code{\link{parents}()},
\code{\link{same_nodes}()},
\code{\link{spouses}()},
\code{\link{subgraph}()},
\code{\link{topological_sort}()}
}
\concept{queries}
