% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{caugi_layout_tiered}
\alias{caugi_layout_tiered}
\title{Tiered Graph Layout}
\usage{
caugi_layout_tiered(x, tiers, orientation = c("columns", "rows"))
}
\arguments{
\item{x}{A \code{caugi} object.}

\item{tiers}{Tier assignments specifying which tier each node belongs to.
Can be provided in multiple formats:
\itemize{
\item \strong{Named list}: List where each element is a character vector of node
names belonging to that tier. Element names are ignored; tier order is
determined by list order (first element = tier 0, etc.).
\item \strong{Named numeric vector}: Vector where names are node names and values
are tier indices (starting from 0 or 1).
\item \strong{Data.frame}: Must contain columns \code{name} (node names) and \code{tier}
(tier indices).
}

All nodes must be assigned to a tier, all tiers must be non-empty, and
tier indices must be consecutive starting from 0 or 1.}

\item{orientation}{Character string specifying the layout orientation:
\itemize{
\item \code{"columns"}: Vertical tiers. First tier at left (x=0),
subsequent tiers to the right, last tier at right (x=1).
\item \code{"rows"}: Horizontal tiers. First tier at top (y=1),
subsequent tiers below, last tier at bottom (y=0).
}}
}
\value{
A \code{data.frame} with columns \code{name}, \code{x}, \code{y}, and \code{tier} containing
node names, their coordinates, and tier assignments (0-indexed). The
returned data.frame also has an \code{orientation} attribute storing the
orientation used. When passed to \code{plot()}, tier information is
automatically extracted, so you don't need to specify \code{tiers} again.
}
\description{
Computes node coordinates for graphs with multiple tiers (layers), placing
nodes in parallel rows or columns based on tier assignments. If the graph
has not been built yet, it will be built automatically before computing
the layout.
}
\examples{
# Create a three-tier causal graph (exposures -> mediators -> outcome)
cg <- caugi(
  X1 \%-->\% M1 + M2,
  X2 \%-->\% M1 + M2,
  M1 \%-->\% Y,
  M2 \%-->\% Y
)

# Option 1: Named list (tier names are just labels)
tiers <- list(
  exposures = c("X1", "X2"),
  mediators = c("M1", "M2"),
  outcome = "Y"
)
layout_rows <- caugi_layout_tiered(cg, tiers, orientation = "rows")

# Option 2: Named numeric vector (0-indexed or 1-indexed both work)
tiers <- c(X1 = 1, X2 = 1, M1 = 2, M2 = 2, Y = 3)
layout_cols <- caugi_layout_tiered(cg, tiers, orientation = "columns")

# Option 3: Data.frame
tiers <- data.frame(
  name = c("X1", "X2", "M1", "M2", "Y"),
  tier = c(1, 1, 2, 2, 3)
)
layout <- caugi_layout_tiered(cg, tiers, orientation = "rows")

# The layout includes tier information, so plot() works without passing tiers
plot(cg, layout = layout)

}
\seealso{
Other plotting: 
\code{\link{add-caugi_plot-caugi_plot}},
\code{\link{caugi_layout}()},
\code{\link{caugi_layout_bipartite}()},
\code{\link{caugi_layout_fruchterman_reingold}()},
\code{\link{caugi_layout_kamada_kawai}()},
\code{\link{caugi_layout_sugiyama}()},
\code{\link{caugi_plot}()},
\code{\link{divide-caugi_plot-caugi_plot}},
\code{\link{plot}()}
}
\concept{plotting}
