% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{caugi_layout_kamada_kawai}
\alias{caugi_layout_kamada_kawai}
\title{Kamada-Kawai Stress Minimization Layout}
\source{
Kamada, T., & Kawai, S. (1989). An algorithm for drawing general
undirected graphs. Information Processing Letters, 31(1), 7-15.
\doi{10.1016/0020-0190(89)90102-6}
}
\usage{
caugi_layout_kamada_kawai(x, packing_ratio = 1.618034, ...)
}
\arguments{
\item{x}{A \code{caugi} object.}

\item{packing_ratio}{Aspect ratio for packing disconnected components
(width/height). Default is the golden ratio (1.618) which works well with
widescreen displays. Use \code{1.0} for square grid, \code{2.0} for wider layouts,
\code{0.5} for taller layouts, \code{Inf} for single row, or \code{0.0} for single column.}

\item{...}{Ignored. For future extensibility.}
}
\value{
A \code{data.frame} with columns \code{name}, \code{x}, and \code{y} containing node
names and their coordinates.
}
\description{
Computes node coordinates using the Kamada-Kawai stress minimization
algorithm. High-quality force-directed layout that minimizes "stress" by
making Euclidean distances proportional to graph-theoretic distances. Better
preserves global structure and path lengths compared to Fruchterman-Reingold.
Ideal for publication-quality visualizations. Works with all edge types and
produces deterministic results.
}
\examples{
cg <- caugi(
  A \%-->\% B,
  B \%<->\% C,
  C \%-->\% D
)
layout <- caugi_layout_kamada_kawai(cg)

}
\seealso{
Other plotting: 
\code{\link{add-caugi_plot-caugi_plot}},
\code{\link{caugi_layout}()},
\code{\link{caugi_layout_bipartite}()},
\code{\link{caugi_layout_fruchterman_reingold}()},
\code{\link{caugi_layout_sugiyama}()},
\code{\link{caugi_layout_tiered}()},
\code{\link{caugi_plot}()},
\code{\link{divide-caugi_plot-caugi_plot}},
\code{\link{plot}()}
}
\concept{plotting}
