% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_glm_initialization.R
\name{cat_glm_initialization}
\alias{cat_glm_initialization}
\title{Initialization for Catalytic Generalized Linear Models (GLMs)}
\usage{
cat_glm_initialization(
  formula,
  family = "gaussian",
  data,
  syn_size = NULL,
  custom_variance = NULL,
  gaussian_known_variance = FALSE,
  x_degree = NULL,
  resample_only = FALSE,
  na_replace = stats::na.omit
)
}
\arguments{
\item{formula}{A formula specifying the GLMs. Should include response and predictor variables.}

\item{family}{The type of GLM family. Defaults to Gaussian.}

\item{data}{A data frame containing the data for modeling.}

\item{syn_size}{An integer specifying the size of the synthetic dataset to be generated. Default is four times the number of predictor columns.}

\item{custom_variance}{A custom variance value to be applied if using a Gaussian model. Defaults to \code{NULL}.}

\item{gaussian_known_variance}{A logical value indicating whether the data variance is known. Defaults to \code{FALSE}. Only applicable to Gaussian family.}

\item{x_degree}{A numeric vector indicating the degree for polynomial expansion of predictors. Default is 1 for each predictor.}

\item{resample_only}{A logical indicating whether to perform resampling only. Default is FALSE.}

\item{na_replace}{A function to handle NA values in the data. Default is \code{stats::na.omit}.}
}
\value{
A list containing the values of all the input arguments and the following components:
\itemize{
\item \strong{Function Information}
\itemize{
\item \code{function_name}: The name of the function, "cat_glm_initialization".
\item \code{y_col_name}: The name of the response variable in the dataset.
\item \code{simple_model}: An object of class \code{stats::glm}, representing the fitted model for generating synthetic response from the original data.
}
\item \strong{Observation Data Information}
\itemize{
\item \code{obs_size}: Number of observations in the original dataset.
\item \code{obs_data}: Data frame of standardized observation data.
\item \code{obs_x}: Predictor variables for observed data.
\item \code{obs_y}: Response variable for observed data.
}
\item \strong{Synthetic Data Information}
\itemize{
\item \code{syn_size}: Number of synthetic observations generated.
\item \code{syn_data}: Data frame of synthetic predictor and response variables.
\item \code{syn_x}: Synthetic predictor variables.
\item \code{syn_y}: Synthetic response variable.
\item \code{syn_x_resample_inform}: Information about resampling methods for synthetic predictors:
\itemize{
\item Coordinate: Preserves the original data values as reference coordinates during processing.
\item Deskewing: Adjusts the data distribution to reduce skewness and enhance symmetry.
\item Smoothing: Reduces noise in the data to stabilize the dataset and prevent overfitting.
\item Flattening: Creates a more uniform distribution by modifying low-frequency categories in categorical variables.
\item Symmetrizing: Balances the data around its mean to improve statistical properties for model fitting.
}
}
\item \strong{Whole Data Information}
\itemize{
\item \code{size}: Total number of combined original and synthetic observations.
\item \code{data}: Data frame combining original and synthetic datasets.
\item \code{x}: Combined predictor variables from original and synthetic data.
\item \code{y}: Combined response variable from original and synthetic data.
}
}
}
\description{
This function prepares and initializes a catalytic Generalized Linear Models (GLMs) by processing input data,
extracting necessary variables, generating synthetic datasets, and fitting a model.
}
\examples{
gaussian_data <- data.frame(
  X1 = stats::rnorm(10),
  X2 = stats::rnorm(10),
  Y = stats::rnorm(10)
)

cat_init <- cat_glm_initialization(
  formula = Y ~ 1, # formula for simple model
  data = gaussian_data,
  syn_size = 100, # Synthetic data size
  custom_variance = NULL, # User customized variance value
  gaussian_known_variance = TRUE, # Indicating whether the data variance is known
  x_degree = c(1, 1), # Degrees for polynomial expansion of predictors
  resample_only = FALSE, # Whether to perform resampling only
  na_replace = stats::na.omit # How to handle NA values in data
)
cat_init
}
