% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visible.R
\name{visible}
\alias{visible}
\title{Visibility}
\usage{
visible(x, show)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{show}{A boolean specifying the visibility. One of,
\itemize{
\item \code{TRUE}
\item \code{FALSE}
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{visible()} function adjusts the visibility of a tag element. An
invisible element is both visually hidden and is also hidden from screen
readers.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    visible(FALSE),
  "Not visible"
)

}
