% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breakpoints.R
\name{breakpoints}
\alias{breakpoints}
\title{Different values for different browser sizes}
\description{
Many functions in cascadess accept multiple name-value pairs via \code{...}. Each
argument's name specifies a breakpoint, a browser width. At this breakpoint,
at this browser width, the argument value will supercede any values specified
for smaller breakpoints, smaller browser widths.

Breakpoints are browser or device widths and enable developing responsive web
applications. A responsive web application will adjust its layout and style
to accomodate the size of a user's browser or device. A web application with
a responsive design allows users to constructively interact from a browser,
phone, tablet, or other device.
\subsection{Available breakpoints}{

\strong{extra small (unnamed or xs)}

Specify an unnamed value for this breakpoint or use the name \code{xs}. This is
the only breakpoint which may be unnamed. However, when specifying multiple
breakpoints the best practice is to use the \code{xs} name.

The value and style are always applied unless superceded by a larger
breakpoint.

\strong{small (sm)}

Specify a value for this breakpoint using the name \code{sm}.

The value and style are applied when the viewport is at least 576px wide,
think landscape phone.

\strong{medium (md)}

Specify a value for this breakpoint using the name \code{md}.

The value and style are applied when the viewport is at least 768px wide,
think tablet.

\strong{large (lg)}

Specify a value for this breakpoint using the name \code{lg}.

The value and style are applied when the viewport is at least 992px wide,
think laptop or smaller desktops.

\strong{extra large (xl)}

Specify a value for this breakpoint using the name \code{xl}.

The value and style are applied when the viewport is at least 1200px wide,
think large desktops.

\strong{extra extra large (xxl)}

Specify a value for this breakpoint using the name \code{xxl}.

The value and style are applied when the viewport is at least 1400px wide,
think larger desktops.
}

\subsection{Further reading}{

These breakpoints are chosen by and are a part of the Bootstrap library
cascadess is built upon. The Bootstrap website goes into greater detail on
their design, construction, and usage, see
\url{https://getbootstrap.com/docs/5.3/layout/breakpoints/}.
}
}
\examples{

library(htmltools)

div(
  .style \%>\%
    flex_display() \%>\%
    flex_direction(xs = "column", lg = "row")
)

div(
  .style \%>\%
    flex_display() \%>\%
    gap_all(xs = 0, md = 2, xl = 4)
)

}
