% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wordcloudLayer.R
\name{wordcloudLayer}
\alias{wordcloudLayer}
\title{Wordcloud Layer}
\usage{
wordcloudLayer(
  x,
  txt,
  freq,
  max.words = NULL,
  cex.maxmin = c(1, 0.5),
  rot.per = 0.1,
  col = NULL,
  fittopol = FALSE,
  use.rank = FALSE,
  add = FALSE,
  breaks = NULL,
  method = "quantile",
  nclass = NULL
)
}
\arguments{
\item{x}{an sf object, a simple feature collection (POLYGON or MULTIPOLYGON).}

\item{txt}{labels variable.}

\item{freq}{frequencies of \code{txt}.}

\item{max.words}{Maximum number of words to be plotted. least frequent terms dropped}

\item{cex.maxmin}{integer (for same size in all \code{txt}) or vector of length 2 indicating the range of the size of the words.}

\item{rot.per}{proportion words with 90 degree rotation}

\item{col}{color or vector of colors words from least to most frequent}

\item{fittopol}{logical. If true would override \code{rot.per} for some elements of \code{x}}

\item{use.rank}{logical. If true rank of frequencies is used instead of real frequencies.}

\item{add}{whether to add the layer to an existing plot (TRUE) or not (FALSE)}

\item{breaks, method, nclass}{additional arguments for adjusting the colors of \code{txt}, see \code{\link{choroLayer}}.}
}
\description{
Plot a word cloud adjusted to an \code{sf} object.
}
\examples{
library(sf) 
mtq <- st_read(system.file("gpkg/mtq.gpkg", package = "cartography"))
par(mar=c(0,0,0,0))
plot(st_geometry(mtq),
     col = "white",
     bg = "grey95",
     border = NA)
wordcloudLayer(
  x = mtq,
  txt = "LIBGEO",
  freq = "POP",
  add = TRUE,
  nclass = 5
)
legendChoro(
  title.txt = "Population",
  breaks = getBreaks(mtq$POP, nclass = 5, method = "quantile"),
  col = carto.pal("blue.pal", 5),
  nodata = FALSE
)
}
\references{
Ian Fellows (2018). wordcloud: Word Clouds.\cr\cr
 R package version 2.6. \url{https://CRAN.R-project.org/package=wordcloud}
}
\seealso{
\link{choroLayer}, \link{legendChoro}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
