% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paper_emissions.R
\name{paper_emissions}
\alias{paper_emissions}
\title{Paper emissions}
\usage{
paper_emissions(
  use = stats::setNames(numeric(), character()),
  waste = TRUE,
  material_production = "Primary material production",
  waste_disposal = c("Closed-loop", "Combustion", "Composting", "Landfill"),
  units = c("kg", "tonnes"),
  value_col = c("value", "value_2024"),
  strict = TRUE
)
}
\arguments{
\item{use}{Named numeric vector of paper quantities in tonnes.
Names matched case/space/punctuation-insensitively to \verb{Level 3}
(drops a leading \code{"Paper: "} prefix and trailing parentheses).
Canonical names: \code{board}, \code{mixed}, \code{paper}. Unknown names warn and are ignored.}

\item{waste}{Logical. If \code{TRUE}, waste tonnages are the same as \code{use}.
If \code{FALSE}, no waste is applied.}

\item{material_production}{Either a single string applied to all paper types
(e.g., \code{"Primary material production"} or \code{"Closed-loop source"}),
or a named vector per paper type, e.g.
\code{c(board = "Closed-loop source", mixed = "Primary material production")}.
If you provide a per-material vector for a subset, unspecified types default to
\code{"Primary material production"}.}

\item{waste_disposal}{One of \code{"Closed-loop"}, \code{"Combustion"}, \code{"Composting"}, \code{"Landfill"}.}

\item{units}{Output units: \code{"kg"} (default) or \code{"tonnes"}.}

\item{value_col}{Which numeric column in \code{uk_gov_data} to use: \code{"value"} or \code{"value_2024"}.}

\item{strict}{If \code{TRUE} (default), error when any nonzero \code{use}/waste needs a
factor that is absent in the table. If \code{FALSE}, treat missing factors as 0.}
}
\value{
Numeric total emissions in requested \code{units}.
}
\description{
Computes embodied GHG emissions for paper using \code{uk_gov_data} rows with
Level 2 = "Paper". Material-use factors come from
\verb{Level 1 = "Material use", Column Text = material_production}.
Waste factors come from \verb{Level 1 = "Waste disposal", Column Text = waste_disposal}.
Factors are kg CO2e per tonne.
}
\examples{
# Closed-loop source for all paper types; landfill; waste = use
paper_emissions(
  use = c(board = 10, paper = 100),
  material_production = "Closed-loop source",
  waste_disposal = "Landfill",
  waste = TRUE
)

# Per-material: board closed-loop, mixed primary (default), no waste
paper_emissions(
  use = c(board = 5, mixed = 2),
  material_production = c(board = "closed loop"),
  waste = FALSE,
  value_col = "value_2024",
  units = "tonnes"
)
}
