% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/material_emissions.R
\name{material_emissions}
\alias{material_emissions}
\title{Material (and waste) emissions — vector-first wrapper}
\usage{
material_emissions(
  paper_use = stats::setNames(numeric(), character()),
  plastic_use = stats::setNames(numeric(), character()),
  metal_use = stats::setNames(numeric(), character()),
  electrical_use = stats::setNames(numeric(), character()),
  construction_use = stats::setNames(numeric(), character()),
  paper_waste = TRUE,
  plastic_waste = TRUE,
  metal_waste = TRUE,
  electrical_waste = TRUE,
  construction_waste = TRUE,
  paper_material_production = "Primary material production",
  metal_material_production = "Primary material production",
  construction_material_production = "Primary material production",
  paper_waste_disposal = c("Closed-loop", "Combustion", "Composting", "Landfill"),
  plastic_waste_disposal = c("Landfill", "Open-loop", "Closed-loop", "Combustion"),
  metal_waste_disposal = c("Closed-loop", "Combustion", "Landfill", "Open-loop"),
  electrical_waste_disposal = c("Landfill", "Open-loop"),
  construction_waste_disposal = c("Closed-loop", "Combustion", "Composting", "Landfill",
    "Open-loop"),
  glass = 0,
  glass_waste = TRUE,
  glass_waste_disposal = c("Closed-loop", "Combustion", "Landfill", "Open-loop"),
  industrial_waste = 0,
  industrial_waste_disposal = c("Combustion", "Landfill"),
  units = c("kg", "tonnes"),
  value_col = c("value", "value_2024"),
  strict = TRUE
)
}
\arguments{
\item{paper_use, plastic_use, metal_use, electrical_use, construction_use}{Named numeric vectors of quantities in tonnes (defaults empty).}

\item{paper_waste, plastic_waste, metal_waste, electrical_waste, construction_waste, glass_waste}{Logical flags: if \code{TRUE}, apply waste factors to the same tonnages as \code{use}.}

\item{paper_material_production, metal_material_production, construction_material_production}{Either a single string (applied to all materials) or a named vector per material.
Common values: \code{"Primary material production"}, \code{"Closed-loop source"}, \code{"Closed-loop"},
\code{"Open-loop"}, \code{"Combustion"}, \code{"Landfill"} (availability depends on the table).}

\item{paper_waste_disposal, plastic_waste_disposal, metal_waste_disposal, electrical_waste_disposal, construction_waste_disposal, glass_waste_disposal}{Waste route to use for the family. See the calculators' docs for valid choices.
(Electrical typically: \code{"Landfill"}, \code{"Open-loop"}; Construction supports \code{"Closed-loop"},
\code{"Combustion"}, \code{"Composting"}, \code{"Landfill"}, \code{"Open-loop"} with material-specific availability.)}

\item{glass}{Numeric tonnage of glass (material use).}

\item{industrial_waste}{Numeric tonnage of commercial and industrial waste (end-of-life only).}

\item{industrial_waste_disposal}{\code{"Combustion"} or \code{"Landfill"}.}

\item{units}{Output units: \code{"kg"} or \code{"tonnes"} (default \code{"kg"}).}

\item{value_col}{Which factor column in \code{uk_gov_data} to use: \code{"value"} or \code{"value_2024"}.}

\item{strict}{If \code{TRUE} (default), error when a required factor is missing; if \code{FALSE}, treat missing factors as 0.}
}
\value{
Total emissions in the requested \code{units}.
}
\description{
Convenience wrapper that sums emissions from paper, plastics, metals,
electrical items, construction materials, glass, and industrial waste.
It forwards to the dedicated calculators:
\code{\link[=paper_emissions]{paper_emissions()}}, \code{\link[=plastic_emissions]{plastic_emissions()}}, \code{\link[=metal_emissions]{metal_emissions()}},
\code{\link[=electrical_emissions]{electrical_emissions()}}, and \code{\link[=construction_emissions]{construction_emissions()}}.
}
\details{
For each family you provide a named \code{use} vector in tonnes plus a
\code{waste = TRUE/FALSE} flag (waste tonnage equals \code{use} when \code{TRUE}).
Unknown names are ignored by the underlying calculators (with warnings).
}
\section{Canonical names (examples)}{

\itemize{
\item Paper: \code{board}, \code{mixed}, \code{paper}
\item Plastics: \code{average}, \code{average_film}, \code{average_rigid}, \code{hdpe}, \code{ldpe}, \code{lldpe}, \code{pet}, \code{pp}, \code{ps}, \code{pvc}
\item Metals: \code{aluminium} (cans/foil), \code{mixed_cans}, \code{scrap}, \code{steel_cans}
\item Electrical: \code{fridges}, \code{freezers}, \code{large_electrical}, \code{it}, \code{small_electrical},
\code{alkaline_batteries}, \code{liion_batteries}, \code{nimh_batteries}
\item Construction: use the material names supported by \code{\link[=construction_emissions]{construction_emissions()}}
}
}

\section{Backwards compatibility}{

Legacy scalar arguments (e.g. \code{board}, \code{HDPE}, \code{fridges}, \code{aluminuim_cans}, …) are
still accepted and are added into the corresponding \verb{*_use} vectors.
Legacy \verb{*_WD} arguments (separate waste tonnages) are deprecated and ignored;
supply \verb{*_waste = TRUE} instead.
}

\examples{
# Paper + Metals + Glass, with waste to the same tonnages
material_emissions(
  paper_use = c(board = 10, paper = 5),
  metal_use = c(aluminium = 0.4, steel_cans = 0.2),
  glass = 3, glass_waste = TRUE,
  paper_waste_disposal = "Closed-loop",
  metal_waste_disposal = "Landfill",
  glass_waste_disposal = "Closed-loop",
  units = "kg"
)
}
