% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CARA_function.R
\name{WBR_Sim_Surv}
\alias{WBR_Sim_Surv}
\title{Simulation Function of Weighted Balance Ratio Design for Survival Response}
\usage{
WBR_Sim_Surv(
  n,
  mu,
  beta,
  gamma,
  m0 = 40,
  pts.X,
  pts.Z,
  censor.time,
  arrival.rate,
  weight,
  v = 2
)
}
\arguments{
\item{n}{a number. The sample size of the simulated data.}

\item{mu}{a number. The true parameters of treatment effect.}

\item{beta}{a vector of length 2. The true parameters of predictive covariate and interaction with treatment.}

\item{gamma}{a vector of length k. The true parameters of prognostic covariates.}

\item{m0}{a positive integer. The number of first 2m0 patients will be allocated equally to both treatments.}

\item{pts.X}{a vector of length n. The vector of patients' binary predictive covariates.}

\item{pts.Z}{a matrix of \code{n x k}. The matrix of patients' binary prognostic covariates.}

\item{censor.time}{a positive number. The upper bound of the uniform censor time in year.}

\item{arrival.rate}{a positive integer. The arrival rate of patients each year.}

\item{weight}{a vector of length \code{2+k}. The weight of balance ratio in overall,margin and stratum levels.}

\item{v}{a positive value that controls the randomness of allocation probability function.}
}
\value{
A list with the following elements:
\item{method}{The name of procedure.}
\item{sampleSize}{The sample size of the trial.}
\item{assignment}{The randomization sequence.}
\item{X1proportion}{Average allocation proportion for treatment A when predictive covariate equals the smaller value.}
\item{X2proportion}{Average allocation proportion for treatment A when predictive covariate equals the larger value.}
\item{proportion}{Average allocation proportion for treatment A.}
\item{N.events}{Total number of events occured of the trial.}
\item{responses}{Observed survival responses of patients.}
\item{events}{Survival status vector of patients(1=event,0=censored)}
\item{rejectNull}{Logical. Indicates whether the treatment effect is statistically significant based on a Wald test.}
}
\description{
This function simulates a trial using Weighted Balance Ratio design for survival responses.
}
\examples{
set.seed(123)

# Simulation settings
n = 400                            # total number of patients
mu = 0.5                           # treatment effect (log hazard ratio)
beta = c(0.5, -0.5)                # predictive effect and interaction
gamma = c(0.5, 0.5)                # prognostic covariate effects
censor.time = 2                   # maximum censoring time (years)
arrival.rate = 1.5                # arrival rate per year
weight = rep(0.25, 4)             # imbalance weights for overall, margins, and stratum

# Generate patient covariates
pts.X = sample(c(1, -1), n, replace = TRUE)  # predictive covariate
pts.Z = cbind(
  sample(c(1, -1), n, replace = TRUE),        # prognostic Z1
  sample(c(1, -1), n, replace = TRUE)         # prognostic Z2
)

# Run simulation for survival outcome
result = WBR_Sim_Surv(
  n = n,
  mu = mu,
  beta = beta,
  gamma = gamma,
  pts.X = pts.X,
  pts.Z = pts.Z,
  censor.time = censor.time,
  arrival.rate = arrival.rate,
  weight = weight

)

}
\concept{Weighted Balance Ratio Design}
