% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FG.R
\name{FG}
\alias{FG}
\alias{FG2}
\title{Flury-Gautschi Common Principal Components}
\usage{
FG(cov_array, p = NULL, m = NULL, maxit = 30L)

FG2(cov_array, p = NULL, m = NULL, maxit = 30L)
}
\arguments{
\item{cov_array}{Numeric 3D array of shape \eqn{p x p x m}
containing covariance matrices in its \eqn{m} slices.}

\item{p}{Optional integer specifying the matrix dimension; defaults to
\code{dim(cov_array)[1]}.}

\item{m}{Optional integer specifying the number of matrices/slices; defaults
to \code{dim(cov_array)[3]}.}

\item{maxit}{Integer scalar; number of outer iterations of the algorithm.}
}
\value{
A \eqn{p x p} numeric matrix of estimated common loadings.
}
\description{
Implements the Flury & Gautschi (1986) (FG) iterative algorithm and a variant to estimate a
common loading matrix across multiple covariance matrices. Each iteration
cycles over all ordered pairs of variable indices and updates a (2 x 2)
rotation so that the transformed matrices share diagonal structure.
}
\details{
Two solvers are exported:
\describe{
\item{\code{FG()}}{The original FG algorithm.}
\item{\code{FG2()}}{An alternative algorithm by Eslami et al. (2013).}
}
}
\examples{
set.seed(1)
p <- 3
m <- 4
mats <- replicate(m,
    {
        A <- matrix(rnorm(p * p), p, p)
        crossprod(A)
    },
    simplify = FALSE
)
cov_cube <- array(NA_real_, dim = c(p, p, m))
for (k in 1:m) cov_cube[, , k] <- mats[[k]]
FG(cov_cube, maxit = 5)
FG2(cov_cube, maxit = 5)

}
\references{
Flury, B. N. (1984). "Common Principal Components in k Groups."
\emph{Journal of the American Statistical Association}, 79, 892-898.

Flury, B. N., & Gautschi, W. (1986). "An Algorithm for Simultaneous
Orthogonal Transformation of Several Positive Definite Symmetric Matrices
to Nearly Diagonal Form." \emph{SIAM Journal on Scientific and Statistical
Computing}, 7(1), 169-184.

Eslami, A., Qannari, E. M., Kohler, A., & Bougeard, S. (2013).
"General Overview of Methods of Analysis of Multi-Group Datasets."
\emph{Revue des Nouvelles Technologies de l'Information}, 25, 108-123.
}
