% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{PsyAcad}
\alias{PsyAcad}
\title{Psychological Measures and Academic Achievement}
\format{
A data frame with 600 observations on the following 8 variables.
\describe{
\item{\code{LocControl}}{locus of control, a numeric vector}
\item{\code{SelfConcept}}{self concept, a numeric vector}
\item{\code{Motivation}}{motivation, a numeric vector}
\item{\code{Read}}{reading score, a numeric vector}
\item{\code{Write}}{writing score, a numeric vector}
\item{\code{Math}}{mathematics score, a numeric vector}
\item{\code{Science}}{science score, a numeric vector}
\item{\code{Sex}}{a factor with levels \code{M}, \code{F}}
}
}
\source{
Taken from \url{https://stats.oarc.ucla.edu/r/dae/canonical-correlation-analysis/}
}
\usage{
data("PsyAcad")
}
\description{
A researcher collected data on three psychological variables, four academic variables
(standardized test scores) and gender for 600 college freshman.
She is interested in how the set of psychological variables relates to the academic variables and gender.
In particular, the researcher is interested in how many dimensions (canonical variables) are necessary to
understand the association between the two sets of variables.
}
\examples{
data(PsyAcad)
PsyAcad$Sex <- as.numeric(PsyAcad$Sex)
PsyAcad.can <- cancor(cbind(LocControl, SelfConcept, Motivation) ~ 
       Read + Write + Math + Science + Sex, data = PsyAcad)

PsyAcad.can

# redundancy analysis
redundancy(PsyAcad.can)

# Plots
canR <- PsyAcad.can$cancor
plot(PsyAcad.can, pch=16, id.n = 3)
text(-2, 3, paste("Can R =", round(canR[1], 3)), pos = 3)

plot(PsyAcad.can, which = 2, pch=16, id.n = 3)
text(-2, 3.5, paste("Can R =", round(canR[2], 3)), pos = 3)

}
\concept{cancor}
\keyword{datasets}
