% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_camtrapdp.R
\name{read_camtrapdp}
\alias{read_camtrapdp}
\title{Read a Camera Trap Data Package}
\usage{
read_camtrapdp(file)
}
\arguments{
\item{file}{Path or URL to a \code{datapackage.json} file.}
}
\value{
A Camera Trap Data Package object.
}
\description{
Reads a \href{https://camtrap-dp.tdwg.org}{Camera Trap Data Package (Camtrap DP)}
dataset into memory.
}
\section{Older versions}{


The \code{read_camtrapdp()} function supports older versions of Camtrap DP and
will automatically \strong{upgrade} such datasets to the latest version of the
standard.
It currently supports versions 1.0, 1.0.1 and 1.0.2 (latest).
}

\section{Events}{


Observations can contain classifications at two levels:
\itemize{
\item \strong{Media-based} observations (\code{observationLevel = "media"}) are based on a
single media file and are directly linked to it via \code{mediaID}.
\item \strong{Event-based} observations (\code{observationLevel = "event"}) are based on an
event, defined as a combination of \code{eventID}, \code{eventStart} and \code{eventEnd}.
This event can consist of one or more media files, but is not directly linked
to these.
}

The \code{read_camtrapdp()} function \strong{will automatically assign \code{eventID}s to
media}, using \code{media.deploymentID = observations.deploymentID} and
\verb{observations.eventStart <= media.timestamp <= observations.eventEnd}.
Note that this can result in media being linked to multiple events (and thus
being duplicated), for example when events and sub-events were defined.
}

\section{Taxonomic information}{


Camtrap DP metadata has a \code{taxonomic} property that can contain extra
information for each \code{scientificName} found in observations.
Such information can include higher taxonomy (\code{family}, \code{order}, etc.) and
vernacular names in multiple languages.

The \code{read_camtrapdp()} function \strong{will automatically include this taxonomic
information in observations}, as extra columns starting with \code{taxon.}.
It will then update the \code{taxonomic} scope in the metadata to the unique
\code{\link[=taxa]{taxa()}} found in the data.
}

\section{Spatial/temporal coverage}{


Camtrap DP metadata has a \code{spatial} and \code{temporal} property that contains the
spatial and temporal coverage of the package respectively.

The \code{read_camtrapdp()} function \strong{will automatically update (or create) the
spatial and temporal scopes} in the metadata based on the data.
It also does this for the taxonomic scope (see higher).
}

\section{Additional resources}{


A Camtrap DP can contain Data Resources not described by the standard.
Those are listed with the tables supported by the standard (i.e. deployments,
media, observations) in the \code{resources} property.

The \code{read_camtrapdp()} function will \strong{ignore these additional resources}
and only read the tables described by the standard.
Additional resources can be read with \code{\link[frictionless:read_resource]{frictionless::read_resource()}} if they
are tabular.
}

\examples{
file <- "https://raw.githubusercontent.com/tdwg/camtrap-dp/1.0.2/example/datapackage.json"
x <- read_camtrapdp(file)
x
}
\concept{read functions}
