% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calba.R
\name{ba_decay}
\alias{ba_decay}
\title{Calculate Basal Area with Decay Function}
\usage{
ba_decay(
  mu_values,
  sp,
  gx,
  gy,
  ba,
  r,
  exponential_normal = FALSE,
  edge_correction = c("none", "safe"),
  bounds = NULL
)
}
\arguments{
\item{mu_values}{A numeric vector of decay parameters. Each value in `mu_values` represents
a decay factor that modifies how the basal area contribution diminishes with distance.}

\item{sp}{A character vector containing species names for each tree.}

\item{gx}{A numeric vector of x-coordinates for the trees.}

\item{gy}{A numeric vector of y-coordinates for the trees.}

\item{ba}{A numeric vector of basal area values for the trees.}

\item{r}{A numeric scalar representing the radius to consider for neighboring trees.}

\item{exponential_normal}{A logical value. If `FALSE` (default), use exponential decay.
If `TRUE`, use exponential-normal decay.}

\item{edge_correction}{Character. See `ba_simple()` for the `"safe"` behavior that skips edge trees.}

\item{bounds}{Optional numeric vector `c(xmin, xmax, ymin, ymax)` giving the plot extent.
When `NULL`, the range of `gx`/`gy` is used; supply bounds if your data do not span the full plot.}
}
\value{
A list with two matrices:
\describe{
  \item{`con_ba_matrix`}{A numeric matrix of basal areas with decay applied for conspecific (same species) trees.}
  \item{`total_ba_matrix`}{A numeric matrix of basal areas with decay applied for all trees (conspecific + heterospecific).}
}
}
\description{
This function calculates the basal area across a given set of trees, applying a decay effect
based on distance and species identity for each tree within a given radius.
}
\details{
The function applies an exponential decay model where the basal area contribution
  diminishes with distance from the focal tree:
  \deqn{\text{decayed basal area} = \text{ba} \cdot \exp\left(-\frac{\text{dist}}{\mu}\right)}
  where `mu` is the decay parameter, `ba` is the basal area, and `dist` is the Euclidean distance
  between trees.
}
\examples{
# Generate a sample dataset
set.seed(42)
sample_data <- data.frame(
  latin = sample(letters[1:4], 100, replace = TRUE),
  gx = runif(100, 0, 10),
  gy = runif(100, 0, 10),
  ba = runif(100, 10, 30)
)
mu_values <- c(1, 3, 5, 7)
ba_decay(
  mu_values = mu_values,
  sp = sample_data$latin,
  gx = sample_data$gx,
  gy = sample_data$gy,
  ba = sample_data$ba,
  r = 3,
  exponential_normal = FALSE
)

}
