% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/digital-ocean.R
\name{do_remove_server}
\alias{do_remove_server}
\title{Remove a deployed application}
\usage{
do_remove_server(droplet, path, delete = FALSE, ...)
}
\arguments{
\item{droplet}{The droplet on which to act.}

\item{path}{The path/name of the application to remove.}

\item{delete}{If \code{TRUE}, also deletes the application files. If \code{FALSE},
just stops and disables the service.}

\item{...}{additional arguments to pass to \code{\link[analogsea:droplet_ssh]{analogsea::droplet_ssh()}}.}
}
\value{
The DigitalOcean droplet
}
\description{
Removes a deployed _server.yml application from the server.
}
\examples{
\dontrun{
  droplet <- analogsea::droplet(123456)

  # Stop the service but keep files
  do_remove_server(droplet, "myapp", delete = FALSE)

  # Remove the service and delete all files
  do_remove_server(droplet, "myapp", delete = TRUE)
}
}
