% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_counterfactuals.R
\name{simulate_counterfactuals}
\alias{simulate_counterfactuals}
\title{Calculate the potential outcomes using marginal survival causual curves}
\usage{
simulate_counterfactuals(bh, surv_cond, M, cpp, loadcpp = TRUE)
}
\arguments{
\item{bh}{A data frame from the \link[survival]{basehaz} function. This is the baseline hazard for the coxph model.}

\item{surv_cond}{A vector containing the marginal causal survival curves from \link[bunsen]{calculate_statistics}.
Each number is the probability of the surviving the time window (t1,t2],... conditional on surviving the prior corresponding window.}

\item{M}{Numeric. The number of simulated counterfactual patients. Suggest to set above 1,000,000 to get robust estimation but it is time comsuming,}

\item{cpp}{Bool. True for using C++ optimization. False for not using C++ optimization. This requires cpp package installed.}

\item{loadcpp}{Bool. True for loading C++ optimization functions. Default is TRUE. This is only used when cpp = TRUE.}
}
\value{
A list containing the simulated event time and simulated status indicator.
}
\description{
Using the marginal survival causal curves from \link[bunsen]{calculate_statistics} to simulate the potential outcomes.
}
\details{
The potential outcomes were simulated by using a Bernoulli distribution from rbinom() and marginal survival causal curves. If M is quite large, we
suggest to use C++ optimization to speed up the calculation.
}
\examples{
library(survival)
data("oak")

cox_event <- coxph(Surv(OS, os.status) ~ trt + btmb + pdl1, data = oak)
#
cox_censor <- coxph(Surv(OS, 1 - os.status) ~ trt + btmb + pdl1, data = oak)

bh <- basehaz(cox_event, centered = FALSE)
s_condi <- calculate_statistics(model = cox_event, trt = "trt")
sim_out_1d <- simulate_counterfactuals(
bh = bh, surv_cond = s_condi$surv_cond0, cpp = FALSE, M = 1000)
}
\references{
Daniel R, Zhang J, Farewell D. Making apples from oranges:
Comparing noncollapsible effect estimators and their standard errors
after adjustment for different covariate sets.
Biom J. 2021;63(3):528-557. doi:10.1002/bimj.201900297
}
