% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_variance_estimation.R
\name{get_variance_estimation}
\alias{get_variance_estimation}
\title{Calculate the variance (SE) of the marginal treatment effects (hazard ratio) adjusting covariates in clinical trials}
\usage{
get_variance_estimation(
  cox_event,
  cox_censor,
  trt,
  data,
  M,
  n.boot,
  seed = NULL,
  cpp = TRUE,
  control = clmqControl(),
  verbose = TRUE
)
}
\arguments{
\item{cox_event}{Object. A coxph model using the survival time and survival status.}

\item{cox_censor}{Object. A coxph model using the survival time and 1-survival status.}

\item{trt}{Character. Variable name of the treatment assignment. Only support two arm trial at the moment.}

\item{data}{A data frame used for cox_event and cox_censor.}

\item{M}{Numeric. The number of simulated counterfactual patients. Suggest to set above 1,000,000 to get robust estimation but it is time comsuming,}

\item{n.boot}{Numeric. Number of bootstrap.}

\item{seed}{Numeric. Random seed for simulation.}

\item{cpp}{Bool. True for using C++ optimization. False for not using C++ optimization. This requires cpp package installed.}

\item{control}{Named list. A list containing control parameters, including memory of remote workers, whether to use nested parallel computation or local multiprocess, number of remote workers/jobs, etc. See details of \link[bunsen]{clmqControl}.}

\item{verbose}{Bool. Print status messages. Default: TRUE}
}
\value{
A vector containing SE and 95\% CI.
}
\description{
Estimate the standard error or variance of the marginal treatment effects using nonparametric bootstrap. Currently,
this only supports clustermq for parallel computation.
}
\details{
If clustermq is not available, we suggest building your own bootstrap like boot and doParallel by using the function -- \link[bunsen]{get_point_estimate}.
This can also get you the SE or variance estimates. If you only run this function, you need to have cox_censor and cox_event in the environment.
}
\examples{
\dontrun{
#Don't run as it requires LSF scheduler
library(survival)
data("oak")

cox_event <- coxph(Surv(OS, os.status) ~ trt + btmb + pdl1, data = oak)
#
cox_censor <- coxph(Surv(OS, 1 - os.status) ~ trt + btmb + pdl1, data = oak)
#
get_variance_estimation(cox_event, cox_censor,
  trt = "trt", data = oak,
  M = 1000, n.boot = 10, control = clmqControl(), cpp = FALSE
)
}
}
\references{
Daniel R, Zhang J, Farewell D. Making apples from oranges:
Comparing noncollapsible effect estimators and their standard errors
after adjustment for different covariate sets.
Biom J. 2021;63(3):528-557. doi:10.1002/bimj.201900297
}
