% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_smard.R
\name{smard_table}
\alias{smard_table}
\title{Fetch SMARD table data}
\usage{
smard_table(filter, region = "DE", timestamp, safe = TRUE, refresh = FALSE)
}
\arguments{
\item{filter}{Filter id.}

\item{region}{Region code.}

\item{timestamp}{Timestamp from indices (ms), POSIXct, or Date.

Timestamps are interpreted in the Europe/Berlin timezone.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}
}
\value{
A tibble of table values.

Includes a \code{time} column with POSIXct timestamps in Europe/Berlin.
}
\description{
Fetch SMARD table data
}
\details{
Returns table-style SMARD data for a single timestamp. Use
\code{\link[=smard_indices]{smard_indices()}} to obtain a valid timestamp. Official docs:
https://smard.api.bund.dev.
}
\examples{
\dontrun{
indices <- smard_indices(410, region = "DE", resolution = "hour")
smard_table(410, region = "DE", timestamp = indices$timestamp[[1]])
}

}
\seealso{
\code{\link[=smard_indices]{smard_indices()}} for timestamps and \code{\link[=smard_timeseries]{smard_timeseries()}} for time series.
}
