% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_autobahn.R
\name{autobahn_parking_lorries}
\alias{autobahn_parking_lorries}
\title{List Autobahn lorry parking areas}
\usage{
autobahn_parking_lorries(road_id, flatten = FALSE, flatten_mode = "json")
}
\arguments{
\item{road_id}{Road identifier.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with lorry parking areas.
}
\description{
List Autobahn lorry parking areas
}
\details{
Returns lorry parking areas for a specific Autobahn road id.
Official docs: https://autobahn.api.bund.dev.
}
\examples{
\dontrun{
roads <- autobahn_roads()
autobahn_parking_lorries(roads$road_id[[1]], flatten = TRUE)
}
}
\seealso{
\code{\link[=autobahn_roads]{autobahn_roads()}} and \code{\link[=autobahn_parking_lorry_details]{autobahn_parking_lorry_details()}}.
}
