% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-files.R
\name{btw_tool_files_read_text_file}
\alias{btw_tool_files_read_text_file}
\title{Tool: Read a file}
\usage{
btw_tool_files_read_text_file(
  path,
  line_start = 1,
  line_end = 1000,
  `_intent` = ""
)
}
\arguments{
\item{path}{Path to a file for which to get information. The \code{path} must be
in the current working directory.}

\item{line_start}{Starting line to read, defaults to 1 (starting from the
first line).}

\item{line_end}{Ending line to read, defaults to 1000. Change only this value
if you want to read more or fewer lines. Use in combination with
\code{line_start} to read a specific line range of the file.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}
}
\value{
Returns a character vector of lines from the file.
}
\description{
Tool: Read a file
}
\examples{
withr::with_tempdir({
  write.csv(mtcars, "mtcars.csv")

  btw_tool_files_read_text_file("mtcars.csv", line_end = 5)
})

}
\seealso{
Other files tools: 
\code{\link{btw_tool_files_code_search}()},
\code{\link{btw_tool_files_list_files}()},
\code{\link{btw_tool_files_write_text_file}()}
}
\concept{files tools}
