% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_draws.R
\name{predict_draws.bgmfit}
\alias{predict_draws.bgmfit}
\alias{predict_draws}
\title{Predicted values from the posterior predictive distribution}
\usage{
\method{predict_draws}{bgmfit}(
  model,
  newdata = NULL,
  resp = NULL,
  dpar = NULL,
  ndraws = NULL,
  draw_ids = NULL,
  re_formula = NA,
  allow_new_levels = FALSE,
  sample_new_levels = "uncertainty",
  incl_autocor = TRUE,
  numeric_cov_at = NULL,
  levels_id = NULL,
  avg_reffects = NULL,
  aux_variables = NULL,
  ipts = 10,
  deriv = 0,
  deriv_model = TRUE,
  summary = TRUE,
  robust = FALSE,
  transform = NULL,
  probs = c(0.025, 0.975),
  xrange = NULL,
  xrange_search = NULL,
  parms_eval = FALSE,
  parms_method = "getPeak",
  idata_method = NULL,
  verbose = FALSE,
  fullframe = NULL,
  dummy_to_factor = NULL,
  expose_function = FALSE,
  usesavedfuns = NULL,
  clearenvfuns = NULL,
  funlist = NULL,
  envir = NULL,
  ...
)

predict_draws(model, ...)
}
\arguments{
\item{model}{An object of class \code{bgmfit}.}

\item{newdata}{An optional data frame for estimation. If \code{NULL}
(default), \code{newdata} is retrieved from the \code{model}.}

\item{resp}{A character string (default \code{NULL}) to specify the response
variable when processing posterior draws for \code{univariate_by} and
\code{multivariate} models. See \code{\link[=bsitar]{bsitar()}} for details on
\code{univariate_by} and \code{multivariate} models.}

\item{dpar}{Optional name of a predicted distributional parameter.
If specified, expected predictions of this parameters are returned.}

\item{ndraws}{A positive integer indicating the number of posterior draws to
use in estimation. If \code{NULL} (default), all draws are used.}

\item{draw_ids}{An integer specifying the specific posterior draw(s) to use
in estimation (default \code{NULL}).}

\item{re_formula}{Option to indicate whether or not to include
individual/group-level effects in the estimation. When \code{NA} (default),
individual-level effects are excluded, and population average growth
parameters are computed. When \code{NULL}, individual-level effects are
included in the computation, and the resulting growth parameters are
individual-specific. In both cases (\code{NA} or \code{NULL}), continuous
and factor covariates are appropriately included in the estimation.
Continuous covariates are set to their means by default (see
\code{numeric_cov_at} for details), while factor covariates remain
unaltered, allowing for the estimation of covariate-specific population
average and individual-specific growth parameters.}

\item{allow_new_levels}{A flag indicating if new levels of group-level
effects are allowed (defaults to \code{FALSE}). Only relevant if
\code{newdata} is provided.}

\item{sample_new_levels}{Indicates how to sample new levels for grouping
factors specified in \code{re_formula}. This argument is only relevant if
\code{newdata} is provided and \code{allow_new_levels} is set to
\code{TRUE}. If \code{"uncertainty"} (default), each posterior sample for a
new level is drawn from the posterior draws of a randomly chosen existing
level. Each posterior sample for a new level may be drawn from a different
existing level such that the resulting set of new posterior draws
represents the variation across existing levels. If \code{"gaussian"},
sample new levels from the (multivariate) normal distribution implied by the
group-level standard deviations and correlations. This options may be useful
for conducting Bayesian power analysis or predicting new levels in
situations where relatively few levels where observed in the old_data. If
\code{"old_levels"}, directly sample new levels from the existing levels,
where a new level is assigned all of the posterior draws of the same
(randomly chosen) existing level.}

\item{incl_autocor}{A flag indicating if correlation structures originally
specified via \code{autocor} should be included in the predictions.
Defaults to \code{TRUE}.}

\item{numeric_cov_at}{An optional (named list) argument to specify the value
of continuous covariate(s). The default \code{NULL} option sets the
continuous covariate(s) to their mean. Alternatively, a named list can be
supplied to manually set these values. For example, \code{numeric_cov_at =
  list(xx = 2)} will set the continuous covariate variable 'xx' to 2. The
argument \code{numeric_cov_at} is ignored when no continuous covariates are
included in the model.}

\item{levels_id}{An optional argument to specify the \code{ids} for the
hierarchical model (default \code{NULL}). It is used only when the model is
applied to data with three or more levels of hierarchy. For a two-level
model, \code{levels_id} is automatically inferred from the model fit. For
models with three or more levels, \code{levels_id} is inferred from the
model fit under the assumption that hierarchy is specified from the lowest
to the uppermost level, i.e., \code{id} followed by \code{study}, where
\code{id} is nested within \code{study}. However, it is not guaranteed that
\code{levels_id} is sorted correctly, so it is better to set it manually
when fitting a model with three or more levels of hierarchy.}

\item{avg_reffects}{An optional argument (default \code{NULL}) to calculate
(marginal/average) curves and growth parameters, such as APGV and PGV. If
specified, it must be a named list indicating the \code{over} (typically a
level 1 predictor, such as age), \code{feby} (fixed effects, typically a
factor variable), and \code{reby} (typically \code{NULL}, indicating that
parameters are integrated over the random effects). For example,
\code{avg_reffects = list(feby = 'study', reby = NULL, over = 'age')}.}

\item{aux_variables}{An optional argument to specify the variable(s) that can
be passed to the \code{ipts} argument (see below). This is useful when
fitting location-scale models and measurement error models. If
post-processing functions throw an error such as \code{variable 'x' not
  found in either 'data' or 'data2'}, consider using \code{aux_variables}.}

\item{ipts}{An integer to set the length of the predictor variable for
generating a smooth velocity curve. If \code{NULL}, the original values are
returned. If an integer (e.g., \code{ipts = 10}, default), the predictor is
interpolated. Note that these interpolations do not alter the range of the
predictor when calculating population averages and/or individual-specific
growth curves.}

\item{deriv}{An integer indicating whether to estimate the distance curve
or its derivative (velocity curve). The default \code{deriv = 0} is for
the distance curve, while \code{deriv = 1} is for the velocity curve.}

\item{deriv_model}{A logical value specifying whether to estimate the
velocity curve from the derivative function or by differentiating the
distance curve. Set \code{deriv_model = TRUE} for functions that require
the velocity curve, such as \code{growthparameters()} and
\code{plot_curves()}. Set it to \code{NULL} for functions that use the
distance curve (i.e., fitted values), such as \code{loo_validation()} and
\code{plot_ppc()}.}

\item{summary}{A logical value indicating whether only the estimate should be
computed (\code{TRUE}), or whether the estimate along with SE and CI should
be returned (\code{FALSE}, default). Setting \code{summary} to \code{FALSE}
will increase computation time. Note that \code{summary = FALSE} is
required to obtain correct estimates when \code{re_formula = NULL}.}

\item{robust}{A logical value to specify the summary options. If \code{FALSE}
(default), the mean is used as the measure of central tendency and the
standard deviation as the measure of variability. If \code{TRUE}, the
median and median absolute deviation (MAD) are applied instead. Ignored if
\code{summary} is \code{FALSE}.}

\item{transform}{A function applied to individual draws from the posterior
distribution before computing summaries. The argument \code{transform} is
based on the \code{\link[marginaleffects:predictions]{marginaleffects::predictions()}} function. This should not be
confused with \code{transform} from \code{\link[brms:posterior_predict.brmsfit]{brms::posterior_predict()}}, which is
now deprecated.}

\item{probs}{The percentiles to be computed by the \code{quantile}
function. Only used if \code{summary} is \code{TRUE}.}

\item{xrange}{An integer to set the predictor range (e.g., age) when
executing the interpolation via \code{ipts}. By default, \code{NULL} sets
the individual-specific predictor range. Setting \code{xrange = 1} applies
the same range for individuals within the same higher grouping variable
(e.g., study). Setting \code{xrange = 2} applies an identical range across
the entire sample. Alternatively, a numeric vector (e.g., \code{xrange =
  c(6, 20)}) can be provided to set the range within the specified values.}

\item{xrange_search}{A vector of length two or a character string
\code{'range'} to set the range of the predictor variable (\code{x}) within
which growth parameters are searched. This is useful when there is more
than one peak and the user wants to summarize the peak within a specified
range of the \code{x} variable. The default value is \code{xrange_search =
  NULL}.}

\item{parms_eval}{A logical value to specify whether or not to compute growth
parameters on the fly. This is for internal use only and is mainly needed
for compatibility across internal functions.}

\item{parms_method}{A character string specifying the method used when
evaluating \code{parms_eval}. The default method is \code{getPeak}, which
uses the \code{\link[sitar:getPeakTrough]{sitar::getPeak()}} function from the \code{sitar} package.
Alternatively, \code{findpeaks} uses the \code{findpeaks} function from the
\code{pracma} package. This parameter is for internal use and ensures
compatibility across internal functions.}

\item{idata_method}{A character string to indicate the interpolation method.
The number of interpolation points is set by the \code{ipts} argument.
Available options for \code{idata_method} are \emph{method 1} (specified as
\code{'m1'}) and \emph{method 2} (specified as \code{'m2'}).
\itemize{
\item \emph{Method 1} (\code{'m1'}) is adapted from the \pkg{iapvbs} package
and is documented
\href{https://rdrr.io/github/Zhiqiangcao/iapvbs/src/R/exdata.R}{here}.
\item \emph{Method 2} (\code{'m2'}) is based on the \pkg{JMbayes} package
and is documented
\href{https://github.com/drizopoulos/JMbayes/blob/master/R/dynPred_lme.R}{here}.
The \code{'m1'} method works by internally constructing the data frame
based on the model configuration, while the \code{'m2'} method uses the
exact data frame from the model fit, accessible via \code{fit$data}. If
\code{idata_method = NULL} (default), method \code{'m2'} is automatically
selected. Note that method \code{'m1'} may fail in certain cases,
especially when the model includes covariates (particularly in
\code{univariate_by} models). In such cases, it is recommended to use
method \code{'m2'}.
}}

\item{verbose}{A logical argument (default \code{FALSE}) to specify whether
to print information collected during the setup of the object(s).}

\item{fullframe}{A logical value indicating whether to return a
\code{fullframe} object in which \code{newdata} is bound to the summary
estimates. Note that \code{fullframe} cannot be used with \code{summary =
  FALSE}, and it is only applicable when \code{idata_method = 'm2'}. A
typical use case is when fitting a \code{univariate_by} model. This option
is mainly for internal use.}

\item{dummy_to_factor}{A named list (default \code{NULL}) to convert dummy
variables into a factor variable. The list must include the following
elements:
\itemize{
\item \code{factor.dummy}: A character vector of dummy variables to be
converted to factors.
\item \code{factor.name}: The name for the newly created factor variable
(default is \code{'factor.var'} if \code{NULL}).
\item \code{factor.level}: A vector specifying the factor levels.
If \code{NULL}, levels are taken from \code{factor.dummy}.
If \code{factor.level} is provided, its length must match
\code{factor.dummy}.
}}

\item{expose_function}{A logical argument (default \code{FALSE}) to indicate
whether Stan functions should be exposed. If \code{TRUE}, any Stan
functions exposed during the model fit using \code{expose_function = TRUE}
in the \code{\link[=bsitar]{bsitar()}} function are saved and can be used in post-processing. By
default, \code{expose_function = FALSE} in post-processing functions,
except in \code{\link[=optimize_model]{optimize_model()}} where it is set to \code{NULL}. If
\code{NULL}, the setting is inherited from the original model fit. It must
be set to \code{TRUE} when adding \code{fit criteria} or \code{bayes_R2}
during model optimization.}

\item{usesavedfuns}{A logical value (default \code{NULL}) indicating whether
to use already exposed and saved Stan functions. This is typically set
automatically based on the \code{expose_functions} argument from the
\code{\link[=bsitar]{bsitar()}} call. Manual specification of \code{usesavedfuns} is rarely
needed and is intended for internal testing, as improper use can lead to
unreliable estimates.}

\item{clearenvfuns}{A logical value indicating whether to clear the exposed
Stan functions from the environment (\code{TRUE}) or not (\code{FALSE}). If
\code{NULL}, \code{clearenvfuns} is set based on the value of
\code{usesavedfuns}: \code{TRUE} if \code{usesavedfuns = TRUE}, or
\code{FALSE} if \code{usesavedfuns = FALSE}.}

\item{funlist}{A list (default \code{NULL}) specifying function names. This
is rarely needed, as required functions are typically retrieved
automatically. A use case for \code{funlist} is when \code{sigma_formula},
\code{sigma_formula_gr}, or \code{sigma_formula_gr_str} use an external
function (e.g., \code{poly(age)}). The \code{funlist} should include
function names defined in the \code{globalenv()}. For functions needing
both distance and velocity curves (e.g., \code{plot_curves(..., opt =
  'dv')}), \code{funlist} must include two functions: one for the distance
curve and one for the velocity curve.}

\item{envir}{The environment used for function evaluation. The default is
\code{NULL}, which sets the environment to \code{parent.frame()}. Since
most post-processing functions rely on \pkg{brms}, it is recommended to set
\code{envir = globalenv()} or \code{envir = .GlobalEnv}, especially for
derivatives like velocity curves.}

\item{...}{Additional arguments passed to the \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}}
function. Please see \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}} for details on the various
options available.}
}
\value{
An array of predicted response values. See \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}}
for details.
}
\description{
The \strong{predict_draws()} function is a wrapper around the
\code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}} function, which obtains predicted values (and
their summary) from the posterior distribution. See
\code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}} for details.
}
\details{
The \strong{predict_draws()} function computes the fitted values
from the posterior distribution. The \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}} function
from the \pkg{brms} package can be used to obtain predicted (distance)
values when the outcome (e.g., height) is untransformed. However, when the
outcome is log or square root transformed, the \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}}
function will return the fitted curve on the log or square root scale. In
contrast, the \strong{predict_draws()} function returns the fitted values
on the original scale. Furthermore, \strong{predict_draws()} also computes
the first derivative (velocity), again on the original scale, after making
the necessary back-transformation. Aside from these differences, both
functions (\code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}} and \strong{predict_draws()}) work
similarly. In other words, the user can specify all the options available
in \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}}.
}
\examples{

\donttest{

# Fit Bayesian SITAR model

# To avoid mode estimation, which takes time, the Bayesian SITAR model is fit 
# to the 'berkeley_exdata' and saved as an example fit ('berkeley_exfit').
# See the 'bsitar' function for details on 'berkeley_exdata' and 
# berkeley_exfit'.

# Check and confirm whether the model fit object 'berkeley_exfit' exists
 berkeley_exfit <- getNsObject(berkeley_exfit)

model <- berkeley_exfit

# Population average distance curve
predict_draws(model, deriv = 0, re_formula = NA)

# Individual-specific distance curves
predict_draws(model, deriv = 0, re_formula = NULL)

# Population average velocity curve
predict_draws(model, deriv = 1, re_formula = NA)

# Individual-specific velocity curves
predict_draws(model, deriv = 1, re_formula = NULL)
 }
 
}
\seealso{
\code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}}
}
\author{
Satpal Sandhu  \email{satpal.sandhu@bristol.ac.uk}
}
