% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expose_model_functions.R
\name{expose_model_functions.bgmfit}
\alias{expose_model_functions.bgmfit}
\alias{expose_model_functions}
\title{Expose User-Defined Stan Functions for Post-Processing}
\usage{
\method{expose_model_functions}{bgmfit}(
  model,
  scode = NULL,
  expose = TRUE,
  select_model = NULL,
  returnobj = TRUE,
  vectorize = FALSE,
  verbose = FALSE,
  envir = NULL,
  ...
)

expose_model_functions(model, ...)
}
\arguments{
\item{model}{An object of class \code{bgmfit}.}

\item{scode}{A character string containing the user-defined Stan function(s)
in \code{Stan} code. If \code{NULL} (the default), the \code{scode} will be
retrieved from the \code{model}.}

\item{expose}{A logical (default \code{TRUE}) to indicate whether to expose
the functions and add them as an attribute to the \code{model}.}

\item{select_model}{A character string (default \code{NULL}) to specify the
model name. This parameter is for internal use only.}

\item{returnobj}{A logical (default \code{TRUE}) to specify whether to return
the model object. If \code{expose = TRUE}, it is advisable to set
\code{returnobj = TRUE}.}

\item{vectorize}{A logical (default \code{FALSE}) to indicate whether the
exposed functions should be vectorized using \code{\link[base:Vectorize]{base::Vectorize()}}. Note that
currently, \code{vectorize} should be set to \code{FALSE}, as setting it to
\code{TRUE} may not work as expected.}

\item{verbose}{A logical argument (default \code{FALSE}) to specify whether
to print information collected during the setup of the object(s).}

\item{envir}{The environment used for function evaluation. The default is
\code{NULL}, which sets the environment to \code{parent.frame()}. Since
most post-processing functions rely on \pkg{brms}, it is recommended to set
\code{envir = globalenv()} or \code{envir = .GlobalEnv}, especially for
derivatives like velocity curves.}

\item{...}{Additional arguments passed to the
\code{\link[rstan:expose_stan_functions]{rstan::expose_stan_functions()}} function. The "..." can be used to set the
compiler, which can be either \code{\link[rstan:stanc]{rstan::stanc()}} or \code{\link[rstan:stan_model]{rstan::stan_model()}}.
You can also pass other compiler-specific arguments such as \code{save_dso}
for \code{\link[rstan:stan_model]{rstan::stan_model()}}. Note that while both \code{\link[rstan:stanc]{rstan::stanc()}} and
\code{\link[rstan:stan_model]{rstan::stan_model()}} can be used as compilers before calling
\code{\link[rstan:expose_stan_functions]{rstan::expose_stan_functions()}}, it is important to note that the
execution time for \code{\link[rstan:stan_model]{rstan::stan_model()}} is approximately twice as long as
\code{\link[rstan:stanc]{rstan::stanc()}}.}
}
\value{
An object of class \code{bgmfit} if \code{returnobj = TRUE};
otherwise, it returns \code{NULL} invisibly.
}
\description{
The \strong{expose_model_functions()} function is a wrapper
around \code{\link[rstan:expose_stan_functions]{rstan::expose_stan_functions()}} that exposes user-defined Stan
function(s). These functions are necessary for post-processing the
posterior draws.
}
\examples{

\donttest{

# Fit Bayesian SITAR model 

# To avoid mode estimation which takes time, the Bayesian SITAR model fit to 
# the 'berkeley_exdata' has been saved as an example fit ('berkeley_exfit').
# See 'bsitar' function for details on 'berkeley_exdata' and 'berkeley_exfit'.

# Check and confirm whether the model fit object 'berkeley_exfit' exists
 berkeley_exfit <- getNsObject(berkeley_exfit)

model <- berkeley_exfit

# To save time, argument expose is set as FALSE, which runs a dummy test 
# and avoids model compilation that often takes time.

expose_model_functions(model, expose = FALSE)
}

}
\seealso{
\code{\link[rstan:expose_stan_functions]{rstan::expose_stan_functions()}}
}
\author{
Satpal Sandhu  \email{satpal.sandhu@bristol.ac.uk}
}
