% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secrets.R
\name{db_secrets_scope_acl_delete}
\alias{db_secrets_scope_acl_delete}
\title{Delete Secret Scope ACL}
\usage{
db_secrets_scope_acl_delete(
  scope,
  principal,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{scope}{Name of the scope to remove permissions.}

\item{principal}{Principal to remove an existing ACL.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Delete the given ACL on the given scope.
}
\details{
You must have the \code{MANAGE} permission to invoke this API.
\itemize{
\item Throws \code{RESOURCE_DOES_NOT_EXIST} if no such secret scope, principal, or
ACL exists.
\item Throws \code{PERMISSION_DENIED} if you do not have permission to make this API
call.
}
}
\seealso{
Other Secrets API: 
\code{\link{db_secrets_delete}()},
\code{\link{db_secrets_list}()},
\code{\link{db_secrets_put}()},
\code{\link{db_secrets_scope_acl_get}()},
\code{\link{db_secrets_scope_acl_list}()},
\code{\link{db_secrets_scope_acl_put}()},
\code{\link{db_secrets_scope_create}()},
\code{\link{db_secrets_scope_delete}()},
\code{\link{db_secrets_scope_list_all}()}
}
\concept{Secrets API}
