% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with_brand_yml.R
\name{with_brand_yml_path}
\alias{with_brand_yml_path}
\alias{local_brand_yml_path}
\title{Temporarily set the \code{BRAND_YML_PATH} environment variable}
\usage{
with_brand_yml_path(path, code)

local_brand_yml_path(path, .local_envir = parent.frame())
}
\arguments{
\item{path}{The path to a brand.yml file.}

\item{code}{\code{[any]}\cr Code to execute in the temporary environment}

\item{.local_envir}{\verb{[environment]}\cr The environment to use for scoping.}
}
\value{
\code{[any]}\cr The results of the evaluation of the \code{code}
argument.
}
\description{
This function sets the \code{BRAND_YML_PATH} environment variable to the specified
path for the duration of the local environment. This ensures that, for the
scope of the local environment, any calls to functions that automatically
discover a \verb{_brand.yml} file will use the path specified.
}
\section{Functions}{
\itemize{
\item \code{with_brand_yml_path()}: Run code in a temporary environment with the
\code{BRAND_YML_PATH} environment variable set to \code{path}.

\item \code{local_brand_yml_path()}: Set the \code{BRAND_YML_PATH} environment variable
for the scope of the local environment (e.g. within the current function).

}}
\examples{
# Create a temporary brand.yml file in a tempdir for this example
tmpdir <- withr::local_tempdir("brand")
path_brand <- file.path(tmpdir, "my-brand.yml")
yaml::write_yaml(
  list(color = list(primary = "#abc123")),
  path_brand
)

with_brand_yml_path(path_brand, {
  brand <- read_brand_yml()
  brand$color$primary
})

}
\seealso{
Other brand.yml helpers: 
\code{\link{brand_color_pluck}()},
\code{\link{brand_has}()},
\code{\link{brand_pluck}()}
}
\concept{brand.yml helpers}
