% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_design.R
\name{GLM design}
\alias{GLM design}
\alias{brainGraph_GLM_design}
\title{Create a design matrix for linear model analysis}
\usage{
brainGraph_GLM_design(
  covars,
  coding = c("dummy", "effects", "cell.means"),
  factorize = TRUE,
  binarize = NULL,
  int = NULL,
  mean.center = FALSE,
  center.how = c("all", "within-groups"),
  center.by = getOption("bg.group")
)
}
\arguments{
\item{covars}{A \code{data.table} of covariates}

\item{coding}{Character string indicating how factor variables will be coded.
Default: \code{'dummy'}}

\item{factorize}{Logical indicating whether to convert \emph{character}
columns into \emph{factor}. Default: \code{TRUE}}

\item{binarize}{Character vector specifying the column name(s) of the
covariate(s) to be converted from type \code{factor} to \code{numeric}.
Default: \code{NULL}}

\item{int}{Character vector specifying the column name(s) of the
covariate(s) to test for an interaction. Default: \code{NULL}}

\item{mean.center}{Logical indicating whether to mean center non-factor
variables. Default: \code{FALSE}}

\item{center.how}{Character string indicating whether to use the grand mean
or groupwise means. Default: \code{'all'}}

\item{center.by}{Character string indicating which grouping variable to use
for calculating means (if applicable). Default: \code{'Group'}}
}
\value{
A numeric matrix. Rownames are subject ID's and column names are the
  variable names. There will be additional attributes recording the
  \code{coding}, \code{factorize}, and \code{mean.center} function arguments.
  There will also be attributes for \code{binarize} and \code{int} if they
  are not \code{NULL}, and \code{center.how} and \code{center.by} if
  \code{mean.center=TRUE}.
}
\description{
\code{brainGraph_GLM_design} takes a \code{data.table} of covariates and
returns a \emph{design matrix} to be used in linear model analysis.
}
\details{
There are three different ways to code factors: \emph{dummy}, \emph{effects},
or \emph{cell-means} (chosen by the argument \code{coding}). \emph{Effects}
coding is sometimes referred to as \emph{deviation} coding. \emph{Dummy}
coding is the default when calling \code{lm}. To understand the difference
between these, see Chapter 8 of the User Guide.
}
\section{Character variables}{

The default behavior is to convert all character columns (excluding the Study
ID column and any that you list in the \code{binarize} argument) to factor
variables. To change this, set \code{factorize=FALSE}. So, if your covariates
include multiple character columns, but you want to convert \emph{Scanner} to
binary instead of a factor, you may still specify \code{binarize='Scanner'}
and get the expected result. \code{binarize} will convert the given factor
variable(s) into numeric variable(s), which is performed \emph{before}
centering (if applicable).
}

\section{Centering}{

The argument \code{mean.center} will mean-center (i.e., subtract the mean of
from each variable) any non-factor variables (including any dummy/indicator
covariates). This is done \emph{after} \dQuote{factorizing} and
\dQuote{binarizing}. If \code{center.how='all'}, then the \dQuote{grand mean}
will be used; otherwise, the groupwise means will be used. The grouping
variable is determined by \code{center.by} and is by default \code{'Group'}.
}

\section{Interactions}{

\code{int} specifies which variables should interact with one another. This
argument accepts both numeric/continuous (e.g., \emph{Age}) and factor
variables (e.g., \emph{Sex}). All interaction combinations will be generated:
if you supply 3 variables, all two-way and the single three-way interaction
will be generated. This variable \emph{must} have at least two elements; it
is otherwise ignored. It is generally recommended that centering be performed
when including interaction terms.
}

\examples{
\dontrun{
# Recreate design matrix when "outcome == measure"
DT <- res.glm$DT.Xy[region == levels(region)[1L],
                    !c('region', res.glm$outcome),
                    with=FALSE]
X <- do.call(brainGraph_GLM_design, c(list(covars=DT),
                                      attributes(res.glm$X)[-c(1L, 2L)]))
all.equal(X, res.glm$X)
}
}
\seealso{
Other GLM functions: 
\code{\link{GLM}},
\code{\link{GLM fits}},
\code{\link{mtpc}()}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\concept{GLM functions}
