% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast.R
\name{forecast.PosteriorBVARs}
\alias{forecast.PosteriorBVARs}
\title{Forecasting using Hierarchical Vector Autoregressions for Dynamic Panel Data}
\usage{
\method{forecast}{PosteriorBVARs}(
  object,
  horizon = 1,
  exogenous_forecast = NULL,
  conditional_forecast = NULL,
  ...
)
}
\arguments{
\item{object}{posterior estimation outcome - an object of class 
\code{PosteriorBVARs} obtained by running the \code{estimate} function.}

\item{horizon}{a positive integer, specifying the forecasting horizon.}

\item{exogenous_forecast}{not used here ATM; included for compatibility with 
generic \code{forecast}.}

\item{conditional_forecast}{a list of length \code{C} containing 
\code{horizon x N} matrices with forecasted values for selected variables. 
These matrices should only contain \code{numeric} or \code{NA} values. The 
entries with \code{NA} values correspond to the values that are forecasted 
conditionally on the realisations provided as \code{numeric} values.}

\item{...}{not used}
}
\value{
A list of class \code{ForecastsPANEL} with \code{C} elements containing 
the draws from the country-specific predictive density and data in a form of 
object class \code{Forecasts} that includes:

\describe{
 \item{forecasts}{an \code{NxhorizonxS} array with the draws from the 
 country-specific predictive density}
 \item{forecast_mean}{an \code{NxhorizonxS} array with the mean of the 
 country-specific predictive density}
 \item{forecast_cov}{an \code{NxNxhorizonxS} array with the covariance of the 
 country-specific predictive density}
 \item{Y}{a \code{T_cxN} matrix with the country-specific data}
}
}
\description{
Samples from the joint predictive density of the dependent 
variables for all countries at forecast horizons 
from 1 to \code{horizon} specified as an argument of the function. 
Also implements conditional forecasting based on the provided projections
for some of the variables.
}
\details{
The package provides a range of options regarding the forecasting procedure.
They are dependent on the model and forecast specifications and include 
Bayesian forecasting many periods ahead, conditional forecasting, and 
forecasting for models with exogenous variables.

\strong{One-period-ahead predictive density.}
The model assumptions provided in the documentation for \code{\link{bpvars}} 
determine the country-specific one-period ahead conditional predictive density 
for the unknown vector \eqn{\mathbf{y}_{c.t+1}} given the data available at 
time \eqn{t} and the parameters of the model. It is multivariate normal with
the mean \eqn{\mathbf{A}_c' \mathbf{x}_{c.t+1}} and the covariance matrix 
\eqn{\mathbf{\Sigma}_c}
\deqn{p(\mathbf{y}_{c.t+1} | \mathbf{x}_{c.t+1}, \mathbf{A}_c, \mathbf{\Sigma}_c) = N_N(\mathbf{A}_c' \mathbf{x}_{c.t+1}, \mathbf{\Sigma}_c)}
where \eqn{\mathbf{x}_{c.t+1}} includes the lagged
values of \eqn{\mathbf{y}_{c.t+1}}, the constant term, and, potentially,
exogenous variables if they were specified by the user. 

\strong{Bayesian predictive density.}
The one-period ahead predictive density is used to sample from the joint 
predictive density of the unknown future values. This predictive density is
defined as a joint density of \eqn{\mathbf{y}_{c.t+h}} at horizons 
\eqn{h = 1,\dots,H}, where \eqn{H} corresponds to the value of argument 
\code{horizon}, given the data available at time \eqn{t}:
\deqn{p( \mathbf{y}_{c.T_c + H}, \dots, \mathbf{y}_{c.T_c + 1} | \mathbf{Y}_c, \mathbf{X}_c) = 
\int p(\mathbf{y}_{c.T_c + H}, \dots, \mathbf{y}_{c.T_c + 1} | \mathbf{Y}_c, \mathbf{X}_c, \mathbf{A}_c, \boldsymbol\Sigma_c)
p( \mathbf{A}_c, \boldsymbol\Sigma_c | \mathbf{Y}_c, \mathbf{X}_c) d(\mathbf{A}_c, \boldsymbol\Sigma_c)}
Therefore, the Bayesian forecast does not depend on the parameter values as
the parameters are integrated out with respect to their posterior distribution.
Consequently, Bayesian forecasts incorporate the uncertainty with respect to
estimation. Sampling from the density is facilitated using the draws from the 
posterior density and sequential sampling from the one-period ahead 
predictive density.

\strong{Conditional forecasting} of some of the variables given the future 
values of the remaining variables is implemented following 
Waggoner and Zha (1999) and is based on the conditional normal density given
the future projections of some of the variables created basing on the 
one-period ahead predictive density.

\strong{Exogenous variables.}
Forecasting with models for which specification argument 
\code{exogenous_variables} was specified required providing the future values
of these exogenous variables in the argument \code{exogenous_forecast} of the
\code{\link{forecast.PosteriorBVARPANEL}} function.

\strong{Truncated forecasts for variables of type 'rate'.}
The package provides the option to truncate the forecasts for variables of 
for which the corresponding element of argument \code{type} of the function 
\code{specify_bvarPANEL$new()} is set to \code{"rate"}. The one-period-ahead
predictive normal density for such variables is truncated to values from 
interval  \eqn{[0,100]}.
}
\examples{
# specify the model
specification = specify_bvars$new( 
  ilo_dynamic_panel[1:5], 
  exogenous = ilo_exogenous_variables[1:5]
)
burn_in       = estimate(specification, 5)             # run the burn-in; use say S = 10000
posterior     = estimate(burn_in, 5)                   # estimate the model; use say S = 10000

# forecast 5 years ahead
predictive    = forecast(posterior, 5, exogenous_forecast = ilo_exogenous_forecasts[1:5])

}
\references{
Waggoner, D. F., & Zha, T. (1999) 
Conditional forecasts in dynamic multivariate models, 
\emph{Review of Economics and Statistics}, \bold{81}(4), 639-651,
\doi{10.1162/003465399558508}.
}
\seealso{
\code{\link{specify_bvars}}, \code{\link{estimate.PosteriorBVARs}}, 
\code{\link{summary.ForecastsPANEL}}, \code{\link{plot.ForecastsPANEL}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
