\name{twosamp.object}
\alias{twosamp.object}
\alias{twosamp}

\title{
  Two-sample Confidence Interval Object 
}
\description{
The \code{twosamp} class is returned by the functions  \code{\link{bpcp2samp}} or \code{\link{delta2samp}}. The  class 
represents the comparison of two survival curves at each observed event time.

Unlike the \code{htest} class, which compares curves at specified testtimes, 
the \code{twosamp} class compares curves at all observed event times.


Objects of this class has methods for the functions \code{summary} and \code{plot}. 


}
\section{Structure}{
The following components must be included in a legitimate 
\code{twosamp} 
object. 
structure(list(L=L, Lin=Lin, R=R, Rin=Rin, 
                interval=interval,
                 g1=g1,est_group1 = est_g1, lower_group1=lower_g1, upper_group1=upper_g1,
                 g2=g2,est_group2 = est_g2, lower_group2=lower_g2, upper_group2=upper_g2,
                 beta = beta, 
                 lower = lower,
                 upper = upper,
                 conf.level = conf.level, 
                 p.value = p.value, 
                 null.value = nullparm, 
                 alternative = alt, 
                 method = full.method), class = c("twosamp","list"))
}
\arguments{
\item{L}{left endpoint of interval}
\item{Lin}{logical vector, include left endpoint?}
\item{R}{right endpoint of interval}
\item{Rin}{logical vector, include right endpoint?}
\item{interval}{interval of survival and confidence interval as determined by \code{L}, \code{Lin}, \code{R}, \code{Rin}}
\item{g1}{name of group 1 as determined by \code{group}}
\item{est_group1}{one-sample survival estimate for group 1 in interval/at time point}
\item{lower_group1}{one-sample lower pointwise confidence limit for group 1 in interval/at time point}
\item{upper_group1}{one-sample upper pointwise confidence limit for group 1 in interval/at time point}
\item{g2}{name of group 2 as determined by \code{group}}
\item{est_group2}{one-sample survival estimate for group 2 in interval/at time point}
\item{lower_group2}{one-sample lower pointwise confidence limit for group 2 in interval/at time point}
\item{upper_group2}{one-sample upper pointwise confidence limit for group 2 in interval/at time point}
\item{beta}{estimate of parameter determined by \code{parmtype} (see note)}
\item{lower}{the lower limit of the confidence interval for the parameter determined by \code{parmtype}}
\item{upper}{the upper limit of the confidence interval for the parameter determined by \code{parmtype}}
\item{conf.level}{confidence level}
\item{p.value}{p-value for the test}
\item{null.value}{the specificed null hypothesized value of the parameter determined by \code{parmtype}}
\item{alternative}{type of alternative with respect to the null.value, either 'two.sided', 'greater' or 'less'}
\item{method}{a character string describing the test}

}
\seealso{
\code{\link{plot.twosamp}},  
\code{\link{summary.twosamp}}
\code{\link{create.twosamp}}
}
\keyword{survival}
