% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box_trailing_commas_linter.R
\name{box_trailing_commas_linter}
\alias{box_trailing_commas_linter}
\title{\code{box} library trailing commas linter}
\usage{
box_trailing_commas_linter(check_functions = FALSE)
}
\arguments{
\item{check_functions}{Boolean flag to include function imports between \code{[} and \verb{]}.
Defaults to FALSE.}
}
\value{
A custom linter function for use with \code{r-lib/lintr}
}
\description{
Checks that all \code{box:use} imports have a trailing comma. This applies to
package or module imports between \code{(} and \verb{)}, and, optionally, function imports between
\code{[} and \verb{]}. Take note that \code{lintr::commas_linter()} may come into play.
}
\details{
For use in \code{rhino}, see the
\href{https://appsilon.github.io/rhino/articles/explanation/rhino-style-guide.html}{Explanation: Rhino style guide}
to learn about the details.
}
\examples{
# will produce lints
lintr::lint(
  text = "box::use(base, rlang)",
  linters = box_trailing_commas_linter()
)

lintr::lint(
  text = "box::use(
   dplyr[select, mutate]
  )",
  linters = box_trailing_commas_linter()
)

# okay
lintr::lint(
  text = "box::use(base, rlang, )",
  linters = box_trailing_commas_linter()
)

lintr::lint(
  text = "box::use(
    dplyr[select, mutate],
  )",
  linters = box_trailing_commas_linter()
)

}
