% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkc.R
\name{pkc}
\alias{pkc}
\title{Plot Kernel Density Estimates for Null and Alternative Distributions.}
\usage{
pkc(nul_dist, alt_dist, alpha)
}
\arguments{
\item{nul_dist}{Numeric vector representing the distribution under the null
hypothesis.}

\item{alt_dist}{Numeric vector representing the distribution under an
alternative hypothesis.}

\item{alpha}{Numeric value between \eqn{[0,0.5]}; the significance level of the test
(type I error rate).}
}
\value{
Creates a plot showing the kernel density estimates of the null and
alternative distributions with the relevant regions highlighted. The function
does not return any values.
}
\description{
Plots kernel density estimates for null and alternative distributions,
showing the acceptance region for a hypothesis test and highlighting
the type II error against an alternative hypothesis.
}
\details{
This function visualizes the kernel density estimates of two
distributions:
one under the null hypothesis and the other one under an alternative hypothesis.
It highlights the acceptance region of the test (using the significance
level \code{alpha})
and the region corresponding to type II error. This visual representation can
be useful for understanding the behaviour of bootstrapped test statistics and the
trade-off between type I and type II errors.
}
\examples{
# Example: Comparing null and alternative distributions
# Generate two normally distributed samples
set.seed(123)
null_dist <- rnorm(1000, mean = 0, sd = 1) # Null distribution
alt_dist <- rnorm(1000, mean = 0.5, sd = 1) # Alternative distribution
alpha <- 0.05 # Significance level

# Plot kernel density estimates
pkc(null_dist, alt_dist, alpha)
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted..

Beran R. (1986).  Simulated Power Functions. \emph{Ann. Statist.}, \bold{14}, 151 - 173.
}
\seealso{
\code{\link{compute_power}}.
}
\keyword{"Bootstrap}
\keyword{Power}
\keyword{testing"}
