% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_td.R
\name{simple_td}
\alias{simple_td}
\title{Generate a simple working-day trading-day regressor}
\usage{
simple_td(dates, df.td)
}
\arguments{
\item{dates}{A vector of class \code{"Date"} corresponding to the weekly observation dates.}

\item{df.td}{A data frame containing daily working-day information with two columns:
\code{date} (class \code{"Date"}) and \code{WORKING_DAY_PART}. Full working days
should be coded as \code{1}; all other values are treated as non-working days.}
}
\value{
A data frame with two columns:
\describe{
\item{date}{Weekly dates corresponding to \code{dates}.}
\item{td}{Centered weekly count of full working days.}
}
The returned object can be merged into a matrix of holiday/trading-day
regressors supplied to \code{boiwsa()} via the \code{H} argument.
}
\description{
Constructs a weekly trading-day regressor by counting the number of full
working days within each weekly period and centering the resulting series by
subtracting its sample mean. Daily working-day information is supplied via
\code{df.td} and mapped to the weekly dates provided in \code{dates}.
}
\examples{

library(dplyr)
data(dates_il)
data(gasoline.data)

dates_il\%>\%
  dplyr::select(DATE_VALUE,ISR_WORKING_DAY_PART)\%>\%
  `colnames<-`(c("date","WORKING_DAY_PART"))\%>\%
  dplyr::mutate(date=as.Date(date))->df.td

td=simple_td(dates = gasoline.data$date,df.td = df.td)




}
