% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/migration-utilities.R
\name{compare_rds_json}
\alias{compare_rds_json}
\title{Compare RDS and JSON Databases}
\usage{
compare_rds_json(rds_path, json_path, ignore_meta = TRUE)
}
\arguments{
\item{rds_path}{Path to RDS file}

\item{json_path}{Path to JSON file}

\item{ignore_meta}{Logical. Ignore metadata fields (those starting with
underscore)? Default is TRUE.}
}
\value{
List of differences, each containing:
\itemize{
\item \code{path}: Location of difference in database structure
\item \code{type}: Type of difference (type_mismatch, missing_in_json,
missing_in_rds, value_mismatch)
\item Additional fields depending on difference type
}
}
\description{
Compares RDS and JSON database files to verify migration accuracy and identify
any differences in structure or content.
}
\details{
This function performs a deep comparison of database structures, checking:
\itemize{
\item Data types match between formats
\item All keys/fields are present in both versions
\item Values are equivalent (accounting for format differences)
}

Useful for verifying that migration from RDS to JSON preserves all data
and structure correctly.
}
\examples{
\donttest{
# Create temporary directories for example
temp_dir <- tempfile()
dir.create(temp_dir)

# Create sample RDS database
sample_db <- list(
  methods = list(
    sampling = "Random sampling",
    analysis = "Regression analysis"
  )
)
rds_path <- file.path(temp_dir, "methods_db.rds")
saveRDS(sample_db, rds_path)

# Convert to JSON
json_path <- file.path(temp_dir, "methods_db.json")
boilerplate_rds_to_json(rds_path, quiet = TRUE)

# Compare original and migrated databases
differences <- compare_rds_json(rds_path, json_path)

if (length(differences) == 0) {
  message("Migration successful - databases are equivalent!")
} else {
  # Review differences
  for (diff in differences) {
    cat(sprintf("Difference at \%s: \%s\n", diff$path, diff$type))
  }
}

# Clean up
unlink(temp_dir, recursive = TRUE)
}

}
\seealso{
\code{\link{boilerplate_migrate_to_json}},
\code{\link{boilerplate_rds_to_json}}
}
