% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boilerplate_batch_edit_functions.R
\name{boilerplate_batch_edit_multi}
\alias{boilerplate_batch_edit_multi}
\title{Batch Edit Multiple Fields at Once}
\usage{
boilerplate_batch_edit_multi(
  db,
  edits,
  category = NULL,
  preview = FALSE,
  confirm = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{db}{List. The database to edit.}

\item{edits}{List of lists. Each sub-list should contain:
\itemize{
\item field: The field to edit
\item new_value: The new value
\item target_entries: Which entries to edit (optional)
\item match_pattern: Pattern to match (optional)
\item match_values: Values to match (optional)
}}

\item{category}{Character. Category to edit if db is unified.}

\item{preview}{Logical. If TRUE, shows what would be changed.}

\item{confirm}{Logical. If TRUE, asks for confirmation.}

\item{quiet}{Logical. If TRUE, suppresses messages.}
}
\value{
List. The modified database with the batch edits applied.
}
\description{
This function allows editing multiple fields across multiple entries in a single operation.
}
\examples{
\donttest{
# First create a sample database
unified_db <- list(
  measures = list(
    ban_hate_speech = list(reference = "old_ref", waves = "1-10"),
    born_nz = list(reference = "old_ref", waves = "1-10")
  )
)

# Update multiple fields for specific entries
unified_db <- boilerplate_batch_edit_multi(
  db = unified_db,
  edits = list(
    list(
      field = "reference",
      new_value = "sibley2021",
      target_entries = c("ban_hate_speech", "born_nz")
    ),
    list(
      field = "waves",
      new_value = "1-15",
      target_entries = c("ban_hate_speech", "born_nz")
    )
  ),
  category = "measures"
)
}

}
