% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_stan_code.R
\name{generate_stan_code_bin}
\alias{generate_stan_code_bin}
\title{Internal function to generate Stan Code for Binary Response Models}
\usage{
generate_stan_code_bin(num_layers, nodes)
}
\arguments{
\item{num_layers}{An integer specifying the number of hidden layers in the neural network.}

\item{nodes}{A vector of integers, where each element specifies the number of nodes
in the corresponding hidden layer. The length of the vector must match \code{num_layers}.}
}
\value{
A character string containing the Stan code for the specified Bayesian neural network model.
The Stan model includes data, parameters, transformed parameters, and model blocks.
The code is adjusted based on whether the network has one or multiple hidden layers.
}
\description{
This function generates Stan code for a Bayesian neural network model
designed to predict binary response variables. The Stan code is dynamically
constructed based on the specified number of hidden layers and nodes per layer.
It supports various activation functions for the hidden layers, including
tanh, sigmoid, softplus and relu. The model uses a Bernoulli likelihood for binary outcomes.
}
\details{
The generated Stan code models a binary response variable using a neural network.
The hidden layers apply the specified activation functions, while the output layer
applies the logistic function to predict the probability of the binary outcome.
\itemize{
\item \strong{For one hidden layer:} The function simplifies the Stan code structure.
\item \strong{For multiple hidden layers:} The code dynamically includes additional layers
based on the input arguments.
}

Supported activation functions for the hidden layers:
\itemize{
\item 1: Tanh
\item 2: Sigmoid
\item 3: Softplus
\item 4: ReLU
\item 5: linear
}

The output layer uses a logistic transformation (\code{inv_logit}) to constrain
predictions between 0 and 1, which aligns with the Bernoulli likelihood.
}
\examples{
# Generate Stan code for a single hidden layer with 10 nodes
stan_code <- generate_stan_code_bin(1, c(10))
cat(stan_code)

# Generate Stan code for two hidden layers with 8 and 4 nodes
stan_code <- generate_stan_code_bin(2, c(8, 4))
cat(stan_code)

}
\keyword{internal}
