% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_positions.R
\name{origin_positions}
\alias{origin_positions}
\alias{origin_positions<-}
\title{Positions of origin locations in a spatial interaction model}
\usage{
origin_positions(sim)

origin_positions(sim) <- value
}
\arguments{
\item{sim}{a spatial interaction model object}

\item{value}{a matrix with as many rows as  the number of origin locations
and 2 or 3 columns, or \code{NULL}}
}
\value{
for \code{origin_positions} \code{NULL} or the coordinate matrix for the
origin locations. for \verb{origin_positions<-} the modified \code{sim} object
}
\description{
Functions to get or set the positions of the origin locations in a spatial
interaction model.
}
\section{Positions}{
Location positions are given by numeric matrices with 2 or 3 columns. The
first two columns are assumed to be geographical coordinates while the 3rd
column can be used for instance to store altitude. Coordinates are
interpreted as is in graphical representations (see \code{\link[=autoplot.sim]{autoplot.sim()}}). They
are not matched to the costs as those can be derived from complex movement
models and other non purely geographic considerations.
}

\examples{
positions <- as.matrix(french_cities[1:10, c("th_longitude", "th_latitude")])
distances <- french_cities_distances[1:10, 1:10] / 1000 ## convert to km
production <- rep(1, 10)
attractiveness <- rep(1, 10)
model <- static_blvim(distances, production, 1.5, 1 / 250, attractiveness)
origin_positions(model) <- positions
origin_positions(model)
}
\seealso{
\code{\link[=location_positions]{location_positions()}}, \code{\link[=destination_positions]{destination_positions()}}
}
