% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_wpc.R
\name{inverse_cost}
\alias{inverse_cost}
\title{Extract the inverse cost scale parameter used to compute this model}
\usage{
inverse_cost(sim, ...)
}
\arguments{
\item{sim}{a spatial interaction model with a inverse cost scale parameter}

\item{...}{additional parameters}
}
\value{
the inverse cost scale parameter
}
\description{
Extract the inverse cost scale parameter used to compute this model
}
\examples{
positions <- matrix(rnorm(10 * 2), ncol = 2)
distances <- as.matrix(dist(positions))
production <- rep(1, 10)
attractiveness <- c(2, rep(1, 9))
model <- static_blvim(distances, production, 1.5, 1, attractiveness)
inverse_cost(model) ## should be 1
}
