% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_df_autoplot.R
\name{autoplot.sim_df}
\alias{autoplot.sim_df}
\title{Create a complete ggplot for a spatial interaction models data frame}
\usage{
\method{autoplot}{sim_df}(object, value, inverse = TRUE, ...)
}
\arguments{
\item{object}{a data frame of spatial interaction models, an object of class
\code{sim_df}}

\item{value}{the value to display, default to \code{diversity} if unspecified}

\item{inverse}{whether to use the cost scale parameter (default)}

\item{...}{additional parameters (not used currently)}
}
\value{
a ggplot object
}
\description{
This function uses a tile plot from ggplot2 to display a single value for
each of the parameter pairs used to produce the collection of spatial
interaction models.
}
\details{
The value to display is specified via an expression evaluated in the context
of the data frame. It defaults to the diversity as computed by \code{\link[=diversity]{diversity()}}.
See the below for examples of use.

The horizontal axis is used by default for the cost scale parameter, that is
\eqn{1/\beta}. This is in general easier to read than using the inverse cost
scale. The \code{inverse} parameter can be used to turn off this feature. The
vertical axis is used by default for the return to scale parameter.
}
\examples{
\dontshow{if (requireNamespace("ggplot2", quietly = TRUE)) withAutoprint(\{ # examplesIf}
positions <- as.matrix(french_cities[1:10, c("th_longitude", "th_latitude")])
distances <- french_cities_distances[1:10, 1:10] / 1000 ## convert to km
production <- rep(1, 10)
attractiveness <- log(french_cities$area[1:10])
all_flows <- grid_blvim(distances, production, seq(1.05, 1.45, by = 0.1),
  seq(1, 3, by = 0.5) / 400,
  attractiveness,
  bipartite = FALSE,
  epsilon = 0.1, iter_max = 1000,
)
all_flows_df <- sim_df(all_flows)

## default display: Shannon diversity
ggplot2::autoplot(all_flows_df)
## iterations
ggplot2::autoplot(all_flows_df, iterations)
## we leverage non standard evaluation to compute a different diversity
ggplot2::autoplot(all_flows_df, diversity(sim, "RW"))
## or to refer to columns of the data frame, either default ones
ggplot2::autoplot(all_flows_df, converged)
ggplot2::autoplot(all_flows_df, iterations)
## or added ones
all_flows_df["Nystuen & Dacey"] <- diversity(sim_column(all_flows_df), "ND")
ggplot2::autoplot(all_flows_df, `Nystuen & Dacey`)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=sim_df]{sim_df()}}, \code{\link[=diversity]{diversity()}}
}
