% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-model-fit-stats.R
\name{blr_rsq_effron}
\alias{blr_rsq_effron}
\title{Effron R2}
\usage{
blr_rsq_effron(model)
}
\arguments{
\item{model}{An object of class \code{glm}.}
}
\value{
Effron pseudo r-squared.
}
\description{
Effron pseudo r-squared.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
            family = binomial(link = 'logit'))

blr_rsq_effron(model)

}
\references{
Efron, B. (1978). Regression and ANOVA with zero-one data: Measures of residual variation. Journal of 
the American Statistical Association, 73, 113-121.
}
\seealso{
Other model fit statistics: 
\code{\link{blr_model_fit_stats}()},
\code{\link{blr_multi_model_fit_stats}()},
\code{\link{blr_pairs}()},
\code{\link{blr_rsq_adj_count}()},
\code{\link{blr_rsq_cox_snell}()},
\code{\link{blr_rsq_mcfadden_adj}()},
\code{\link{blr_rsq_mckelvey_zavoina}()},
\code{\link{blr_rsq_nagelkerke}()},
\code{\link{blr_test_lr}()}
}
\concept{model fit statistics}
