% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-plots.R
\name{blr_plot_pearson_residual}
\alias{blr_plot_pearson_residual}
\title{Residual values plot}
\usage{
blr_plot_pearson_residual(
  model,
  point_color = "blue",
  title = "Standardized Pearson Residuals",
  xaxis_title = "id",
  yaxis_title = "Standardized Pearson Residuals"
)
}
\arguments{
\item{model}{An object of class \code{glm}.}

\item{point_color}{Color of the points.}

\item{title}{Title of the plot.}

\item{xaxis_title}{X axis label.}

\item{yaxis_title}{Y axis label.}
}
\description{
Standardised pearson residuals plot.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
family = binomial(link = 'logit'))

blr_plot_pearson_residual(model)

}
