% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-residual-diagnostics.R
\name{blr_plot_diag_fit}
\alias{blr_plot_diag_fit}
\title{Fitted values diagnostics plot}
\usage{
blr_plot_diag_fit(model, print_plot = TRUE)
}
\arguments{
\item{model}{An object of class \code{glm}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}
}
\value{
A panel of diagnostic plots for fitted values.
}
\description{
Diagnostic plots for fitted values.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
family = binomial(link = 'logit'))

blr_plot_diag_fit(model)

}
\references{
Fox, John (1991), Regression Diagnostics. Newbury Park, CA: Sage Publications.

Cook, R. D. and Weisberg, S. (1982), Residuals and Influence in Regression, New York: Chapman & Hall.
}
\seealso{
Other diagnostic plots: 
\code{\link{blr_plot_diag_influence}()},
\code{\link{blr_plot_diag_leverage}()}
}
\concept{diagnostic plots}
