% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-block.R
\name{new_grid_block}
\alias{new_grid_block}
\title{Grid Block}
\usage{
new_grid_block(
  ncol = character(),
  nrow = character(),
  title = character(),
  subtitle = character(),
  caption = character(),
  tag_levels = character(),
  guides = "auto",
  ...
)
}
\arguments{
\item{ncol}{Number of columns in grid layout (default: NULL for auto)}

\item{nrow}{Number of rows in grid layout (default: NULL for auto)}

\item{title}{Overall plot title (default: "")}

\item{subtitle}{Overall plot subtitle (default: "")}

\item{caption}{Overall plot caption (default: "")}

\item{tag_levels}{Auto-tagging style: 'A', 'a', '1', 'I', 'i', or NULL
(default: NULL)}

\item{guides}{Legend handling: 'auto', 'collect', or 'keep'
(default: 'auto')}

\item{...}{Forwarded to \code{\link[=new_ggplot_transform_block]{new_ggplot_transform_block()}}}
}
\value{
A ggplot transform block object of class \code{grid_block}.
}
\description{
Combines multiple ggplot objects using patchwork::wrap_plots().
Variadic block that accepts 1 or more ggplot inputs with automatic
alignment. Supports layout control (ncol, nrow) and annotations
(title, subtitle, auto-tags).
}
\examples{
# Create a grid block with 2 columns
new_grid_block(ncol = "2")

# Create a grid block with title
new_grid_block(title = "My Combined Plots", ncol = "2")

if (interactive()) {
  library(blockr.core)
  # Grid block requires multiple ggplot inputs
  serve(new_grid_block())
}

}
