% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_expr.R
\name{new_summarize_expr_block}
\alias{new_summarize_expr_block}
\title{Summarize expression block constructor}
\usage{
new_summarize_expr_block(
  exprs = list(count = "dplyr::n()"),
  by = character(),
  unpack = FALSE,
  ...
)
}
\arguments{
\item{exprs}{Reactive expression returning character vector of
expressions}

\item{by}{Columns to define grouping}

\item{unpack}{Logical flag to unpack data frame columns from helper functions.
When \code{TRUE}, expressions that return data frames will have their columns
unpacked into separate columns. When \code{FALSE}, data frames are kept as nested
list-columns. Default is \code{FALSE}.}

\item{...}{Additional arguments forwarded to \code{\link[blockr.core:new_block]{blockr.core::new_block()}}}
}
\value{
A block object for summarize operations
}
\description{
This block allows to add new variables by summarizing over groups using R expressions
(see \code{\link[dplyr:summarise]{dplyr::summarize()}}). Changes are applied after clicking the submit button.
}
\details{
For no-code summarization using dropdowns, see \code{\link[=new_summarize_block]{new_summarize_block()}}.
}
\section{Unpacking Helper Function Results}{

When \code{unpack = TRUE}, helper functions that return data frames will have their
columns unpacked into separate columns in the result. This is useful for helper
functions like \code{stat_label()} that return multiple statistics as columns.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Without unpacking (default)
new_summarize_expr_block(
  exprs = list(stats = "helper_func(...)"),
  unpack = FALSE
)
# Result: Creates nested list-column "stats" containing the data frame

# With unpacking
new_summarize_expr_block(
  exprs = list(stats = "helper_func(...)"),
  unpack = TRUE
)
# Result: Columns from helper_func() are unpacked into separate columns
}\if{html}{\out{</div>}}
}

\examples{
# Create a summarize expression block
new_summarize_expr_block()

if (interactive()) {
  # Basic usage with mtcars dataset
  library(blockr.core)
  serve(new_summarize_expr_block(), list(data = mtcars))

  # With a custom dataset
  df <- data.frame(x = 1:5, y = letters[1:5])
  serve(new_summarize_expr_block(), list(data = df))

  # Using unpack to expand helper function results
  # Define the helper in your environment first
  calc_stats <- function(df) {
    data.frame(
      mean_x = mean(df$x),
      mean_y = mean(df$y),
      sum_x = sum(df$x),
      sum_y = sum(df$y)
    )
  }

  # With unpacking enabled
  serve(
    new_summarize_expr_block(
      exprs = list(stats = "calc_stats(pick(everything()))"),
      by = "group",
      unpack = TRUE
    ),
    list(data = data.frame(x = 1:6, y = 10:15, group = rep(c("A", "B"), 3)))
  )
  # Result: group, mean_x, mean_y, sum_x, sum_y (columns unpacked)
}
}
\seealso{
\code{\link[blockr.core:new_transform_block]{blockr.core::new_transform_block()}}
}
