% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_longer.R
\name{new_pivot_longer_block}
\alias{new_pivot_longer_block}
\title{Pivot Longer block constructor}
\usage{
new_pivot_longer_block(
  cols = character(),
  names_to = "name",
  values_to = "value",
  values_drop_na = FALSE,
  names_prefix = "",
  ...
)
}
\arguments{
\item{cols}{Character vector of column names to pivot into longer format.
If empty, all columns will be available for selection.}

\item{names_to}{Name of the new column to create from the column names.
Default is "name".}

\item{values_to}{Name of the new column to create from the values.
Default is "value".}

\item{values_drop_na}{If TRUE, rows with NA values will be dropped.
Default is FALSE.}

\item{names_prefix}{Optional prefix to remove from column names before storing
in the names_to column. For example, "col_" would remove that prefix from
column names like "col_a", "col_b".}

\item{...}{Additional arguments forwarded to \code{\link[blockr.core:new_transform_block]{blockr.core::new_transform_block()}}}
}
\value{
A block object for pivot_longer operations
}
\description{
This block reshapes data from wide to long format by pivoting multiple columns
into two columns: one containing the original column names and another containing
the values (see \code{\link[tidyr:pivot_longer]{tidyr::pivot_longer()}}).
}
\examples{
# Create a pivot longer block
new_pivot_longer_block()

if (interactive()) {
  # Basic usage with wide format data
  library(blockr.core)
  wide_data <- data.frame(
    id = 1:3,
    measurement_a = c(10, 20, 30),
    measurement_b = c(15, 25, 35),
    measurement_c = c(12, 22, 32)
  )
  serve(
    new_pivot_longer_block(
      cols = c("measurement_a", "measurement_b", "measurement_c"),
      names_to = "measurement_type",
      values_to = "value"
    ),
    data = list(data = wide_data)
  )

  # With names_prefix to clean column names
  serve(
    new_pivot_longer_block(
      cols = c("measurement_a", "measurement_b", "measurement_c"),
      names_to = "type",
      values_to = "measurement",
      names_prefix = "measurement_"
    ),
    data = list(data = wide_data)
  )
}
}
\seealso{
\code{\link[blockr.core:new_transform_block]{blockr.core::new_transform_block()}}, \code{\link[tidyr:pivot_longer]{tidyr::pivot_longer()}}
}
