% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{summarise_tvarstar_posthoc}
\alias{summarise_tvarstar_posthoc}
\title{Summarise nonlinear time-series models (TVAR and LSTAR)}
\usage{
summarise_tvarstar_posthoc(tsdyn_res)
}
\arguments{
\item{tsdyn_res}{A list of model objects, typically with elements
\code{$TVAR}, \code{$LSTAR_I}, \code{$LSTAR_C}, as returned by
a fitting routine based on the \pkg{tsDyn} package.}
}
\value{
A data frame with one row per model and columns:
\itemize{
\item \code{model}: "TVAR", "LSTAR_I", "LSTAR_C".
\item \code{status}: model class string or \code{NA}.
\item \code{aic}: numeric AIC value or \code{NA}.
}
}
\description{
Produces a small summary table for nonlinear time-series models
such as TVAR and LSTAR, focusing on model status and AIC.
}
\details{
For each of the three models (TVAR, LSTAR for I, LSTAR for C),
the function extracts:
\itemize{
\item A textual status (class names of the object).
\item The AIC, if \code{stats::AIC()} can be computed.
}
If \code{tsdyn_res} is \code{NULL}, default rows with \code{NA}
values are returned.
}
