% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ucp.R
\name{hex2ucp}
\alias{hex2ucp}
\alias{int2ucp}
\alias{str2ucp}
\alias{name2ucp}
\alias{is_ucp}
\alias{block2ucp}
\alias{range2ucp}
\title{Get Unicode code points}
\usage{
hex2ucp(x)

int2ucp(x)

str2ucp(x)

name2ucp(x, type = c("exact", "grep"), ...)

is_ucp(x)

block2ucp(x, omit_unnamed = TRUE)

range2ucp(x, omit_unnamed = TRUE)
}
\arguments{
\item{x}{R objects coercible to the respective Unicode character data types.
See \code{\link[Unicode:u_char_basics]{Unicode::as.u_char()}} for \code{hex2ucp()} and \code{int2ucp()},
\code{\link[base:utf8Conversion]{base::utf8ToInt()}} for \code{str2ucp()},
\code{\link[Unicode:u_char_names]{Unicode::u_char_from_name()}} for \code{name2ucp()},
\code{\link[Unicode:u_char_basics]{Unicode::as.u_char_range()}} for \code{range2ucp()},
and \code{\link[Unicode:u_blocks]{Unicode::u_blocks()}} for \code{block2ucp()}.}

\item{type}{one of \code{"exact"} or \code{"grep"}, or an abbreviation
    thereof.
  }

\item{...}{arguments to be passed to \code{\link{grepl}} when using
    this for pattern matching.
  }

\item{omit_unnamed}{Omit control codes or unassigned code points}
}
\value{
A character vector of Unicode code points.
}
\description{
\code{hex2ucp()}, \code{int2ucp()}, \code{name2ucp()}, and \code{str2ucp()} return
Unicode code points as character vectors. \code{is_ucp()} returns
\code{TRUE} if a valid Unicode code point.
}
\details{
\code{hex2ucp(x)} is a wrapper for \code{as.character(Unicode::as.u_char(toupper(x)))}.
\code{int2ucp} is a wrapper for \code{as.character(Unicode::as.u_char(as.integer(x)))}.
\code{str2ucp(x)} is a wrapper for \code{as.character(Unicode::as.u_char(utf8ToInt(x)))}.
\code{name2ucp(x)} is a wrapper for \code{as.character(Unicode::u_char_from_name(x))}.
However missing values are coerced to \code{NA_character_} instead of \code{"<NA>"}.
Note the names of \code{bm_font()} objects must be character vectors as returned
by these functions and not \code{Unicode::u_char} objects.
}
\examples{
  # These are all different ways to get the same 'R' code point
  hex2ucp("52")
  hex2ucp(as.hexmode("52"))
  hex2ucp("0052")
  hex2ucp("U+0052")
  hex2ucp("0x0052")
  int2ucp(82) # 82 == as.hexmode("52")
  int2ucp("82") # 82 == as.hexmode("52")
  int2ucp(utf8ToInt("R"))
  ucp2label("U+0052")
  name2ucp("LATIN CAPITAL LETTER R")
  str2ucp("R")

  block2ucp("Basic Latin")
  block2ucp("Basic Latin", omit_unnamed = FALSE)
  range2ucp("U+0020..U+0030")

}
\seealso{
\code{\link[=ucp2label]{ucp2label()}} and \code{\link[=is_combining_character]{is_combining_character()}}.
}
