% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind.R
\name{cbind.bm_bitmap}
\alias{cbind.bm_bitmap}
\alias{rbind.bm_bitmap}
\alias{cbind.bm_pixmap}
\alias{rbind.bm_pixmap}
\title{Combine bitmap/pixmap objects by rows or columns}
\usage{
\method{cbind}{bm_bitmap}(..., direction = "left-to-right", vjust = "center-top")

\method{rbind}{bm_bitmap}(..., direction = "top-to-bottom", hjust = "center-left")

\method{cbind}{bm_pixmap}(..., direction = "left-to-right", vjust = "center-top")

\method{rbind}{bm_pixmap}(..., direction = "top-to-bottom", hjust = "center-left")
}
\arguments{
\item{...}{\code{\link[=bm_bitmap]{bm_bitmap()}} or \code{\link[=bm_pixmap]{bm_pixmap()}} objects.}

\item{direction}{For \code{cbind()} either "left-to-right" (default) or its aliases "ltr" and "lr"
OR "right-to-left" or its aliases "rtl" and "rl".
For \code{rbind()} either "top-to-bottom" (default) or its aliases "ttb" and "tb"
OR "bottom-to-top" or its aliases "btt" and "bt".
The \code{direction} argument is not case-sensitive.}

\item{vjust}{Used by \code{\link[=bm_extend]{bm_extend()}} if bitmap heights are different.}

\item{hjust}{Used by \code{\link[=bm_extend]{bm_extend()}} if bitmap widths are different.}
}
\value{
A \code{\link[=bm_bitmap]{bm_bitmap()}} or \code{\link[=bm_pixmap]{bm_pixmap()}} object.
}
\description{
\code{cbind.bm_bitmap()} / \code{cbind.bm_pixmap()} and
\code{rbind.bm_bitmap()} / \code{rbind.bm_pixmap()}
combine by columns or rows respectively.
}
\examples{
  font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
  font <- read_hex(font_file)
  capital_b <- font[[str2ucp("B")]]
  capital_m <- font[[str2ucp("M")]]
  cbm <- cbind(capital_b, capital_m)
  print(cbm)
  cbm_rl <- cbind(capital_b, capital_m, direction = "right-to-left")
  print(cbm_rl)
  rbm <- rbind(capital_b, capital_m)
  print(rbm)
  rbm_bt <- rbind(capital_b, capital_m, direction = "bottom-to-top")
  print(rbm_bt)
}
